 /*
  * Khoros: $Id: dfht.c,v 1.2 1992/03/20 23:21:41 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: dfht.c,v 1.2 1992/03/20 23:21:41 dkhoros Exp $";
#endif

 /*
  * $Log: dfht.c,v $
 * Revision 1.2  1992/03/20  23:21:41  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1992, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1992 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: dfht.c
 >>>>
 >>>>      Program Name: dfht
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Take the 1-D Fast Hadamard Transform of a signal.
 >>>>	
 >>>>	

 >>>>            Author: Per Lysne
 >>>>
 >>>> Date Last Updated: Thu Mar  5 10:34:51 1992
 >>>>
 >>>>          Routines: main- the main program for dfht
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "dfht.h"


/****************************************************************
 *
 * Routine Name:  main program for dfht
 *
 *       Input:  
 *      -i  input signal (xviff file) 
 *      -o  output signal (xviff file) 
 *
 *
 *      [-d] data processing direction (n=vectors,y=bands)
 *      [-s] scale fft by 1, 1/N or 1/sqrt(N)
 *		0 (Do not scale the output data),
 *		1 (Scale output data by 1/N),
 *		or 2 (Scale output data by 1/sqrt(N))
 *		   [default = 0] 
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
    struct xvimage *img, *readimage();
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
    if (check_args()) exit(1);

    img = readimage (dfht->i_file);
    if (img==NULL) {
        fprintf (stderr,"error in dfht: could not read %s: ",dfht->i_file);
        fprintf (stderr,"exiting with an error\n");
        exit(1);
    }

    CHECKINPUT (program, img);

    if (img->data_storage_type != VFF_TYP_FLOAT) {
        if (!lvconvert (img, VFF_TYP_FLOAT, 0, 1, 0.0, 1.0, 0)) {
            fprintf (stderr, "error in vslope: call to lvconvert failed\n");
            exit (1);
        }
    }
/* -main_before_lib_call_end */

/* -main_library_call */
    /* 0 parameter indicates a forward transform. */
    if (ldfht(img, dfht->s_toggle, dfht->d_logic)!=1) {
        fprintf (stderr, "error in dfht: library call to ldfht failed: ");
        fprintf (stderr, "exiting with an error\n");
        exit (1);
    }
/* -main_library_call_end */

/* -main_after_lib_call */
    writeimage (dfht->o_file, img);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for dfht 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "dfht :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tTake the 1-D Fast Hadamard Transform of a signal.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input signal (xviff file)  (infile)\n");
	fprintf(stderr,"\t-o  output signal (xviff file)  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-d]  data processing direction (n=vectors,y=bands) (boolean) [true]\n");
	fprintf(stderr, "\t[-s]  scale fft by 1, 1/N or 1/sqrt(N)\n");
	fprintf(stderr, "\t\t0  (Do not scale the output data),\n");
	fprintf(stderr, "\t\t1  (Scale output data by 1/N),\n");
	fprintf(stderr, "\t\tor 2  (Scale output data by 1/sqrt(N))\n");
	fprintf(stderr, "\t\t[default = 0]\n");
	fprintf(stderr, "\n");	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for dfht\n");
	fprintf(stderr, "\t[-U] Gives the usage for dfht\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called dfht.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses dfht.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for dfht
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input signal (xviff file) \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) output signal (xviff file) \n        {outfile}: "; 
char	*d_pstr = 
	"\nEnter: (d) data processing direction (n=vectors,y=bands) \n        {boolean, (y/n)  [yes] }: "; 
char	*s_pstr = "\nEnter: (s) scale fft by 1, 1/N or 1/sqrt(N) -- \n      \t\t0 (Do not scale the output data)\n\t\t1 (Scale output data by 1/N)\n\t\tor 2 (Scale output data by 1/sqrt(N))\n  [0]:  "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "dfht", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "dfht.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "dfht: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "dfht.ans");
		}

	     }

	}

	/*
	 * allocate the dfht structure
	 */
	dfht = (dfht_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (dfht_struct));

	/*
	 * get required arguments for dfht
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(dfht->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(dfht->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(dfht->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    dfht->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(dfht->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(dfht->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(dfht->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(dfht->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    dfht->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(dfht->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for dfht
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	dfht->d_flag = vget_logic(fid, prompt_flag,
	"-d", d_pstr, &(dfht->d_logic), 1);


	/*
	 * get optional toggles for dfht
	 */
	if (prompt_flag == TRUE)
	{
	    ok = FALSE;
	    while(!ok)
	    {
		dfht->s_flag = vget_int(fid, prompt_flag,
		"-s", s_pstr, &(dfht->s_toggle),
		0, 0, 0);

		if ((dfht->s_toggle == 0 ) || 
		    (dfht->s_toggle == 1 ) || 
		    (dfht->s_toggle == 2 ))
		      ok = TRUE;
		else
		{
		}
	    }
	}
	else
	{
		dfht->s_flag = vget_int(fid, prompt_flag,
		"-s", s_pstr, &(dfht->s_toggle),
		0, 0, 0);

		if ((dfht->s_toggle != 0 ) && 
		    (dfht->s_toggle != 1 ) && 
		    (dfht->s_toggle != 2 ))
		{
		    fprintf(stderr, "\n");
		    gw_usage();
		    exit(0);
		}
	}


}



