 /*
  * Khoros: $Id: viff2xbm.h,v 1.1 1991/05/10 15:53:17 khoros Exp $
  */

 /*
  * $Log: viff2xbm.h,v $
 * Revision 1.1  1991/05/10  15:53:17  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: viff2xbm.h
 >>>>            Author: Mark Young, Mike Lang
 >>>> Date Last Updated: Thu Apr  4 17:36:26 1991
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _viff2xbm_h_
#define _viff2xbm_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program,	/* a pointer to the program name argv[0] */
	*calloc();
int	ac;

/****************************************************************
*
*                    viff2xbm Argument Structure
*
****************************************************************/

typedef struct _viff2xbm  {

/*
 *  input image (Required infile)
 */
char	*i_file;	/* input image FILENAME */
int	 i_flag;	/* input image FLAG */

/*
 *  output resulting xbm definition (Required outfile)
 */
char	*o_file;	/* output resulting xbm definition FILENAME */
int	 o_flag;	/* output resulting xbm definition FLAG */

/*
 *  xbm description name (Required string)
 */
char	*n_string;	/* xbm description name STRING */
int	 n_flag;   	/* xbm description name FLAG */

/*
 *  if yes (default) photopositive (Optional logical)
 */
int	 p_logic;	/* if yes (default) photopositive LOGIC */
int	 p_flag;  	/* if yes (default) photopositive FLAG */

}  viff2xbm_struct;

viff2xbm_struct *viff2xbm;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */
#define READINPUT(image) \
        if ((image = readimage(viff2xbm->i_file)) == NULL) exit(1)
#define CHECKINPUT(program, image) \
        (void) proper_num_images(program,image,1,TRUE); \
        (void) propertype(program,image,VFF_TYP_BIT,TRUE); 
/* -include_macros_end */

#endif
