#! /bin/csh -f

# 
#  Khoros: $Id: formatdoc_csh.csh,v 1.2 1991/12/18 08:53:55 dkhoros Exp $
#

#
# $Log: formatdoc_csh.csh,v $
# Revision 1.2  1991/12/18  08:53:55  dkhoros
# HellPatch3
#
# 

#
#*----------------------------------------------------------------------
#*
#* Copyright 1991, University of New Mexico.  All rights reserved.
#*
#* Permission to copy and modify this software and its documen-
#* tation only for internal use in your organization is hereby
#* granted, provided that this notice is retained thereon and
#* on all copies.  UNM makes no representations as too the sui-
#* tability and operability of this software for any purpose.
#* It is provided "as is" without express or implied warranty.
#* 
#* UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
#* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
#* NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
#* INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
#* SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
#* IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
#* ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
#* FORMANCE OF THIS SOFTWARE.
#* 
#* No other rights, including for example, the right to redis-
#* tribute this software and its documentation or the right to
#* prepare derivative works, are granted unless specifically
#* provided in a separate license agreement.
#*---------------------------------------------------------------------
#

#include "unmcopyright.h"	 /* Copyright 1991 by UNM */


#  >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
#  >>>>                                                       <<<<
#  >>>>	    file name: formatdoc_csh.csh                      <<<<
#  >>>>                                                       <<<<
#  >>>>   description: utility for formatting khoros help pages
#  >>>>                                                       <<<<
#  >>>> modifications:					      <<<<
#  >>>>                                                       <<<<
#  >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< 

# ROUTINE NAME: formatdoc_csh
#
# DESCRIPTION: This shell script will format doc and help pages for 
#		   khoros/doc
#
# AUTHORS:      Tom Sauer, Carla Williams 
#
# DATE:         7/18/90
#
# MODIFICATIONS: Tues Mar 5 Danielle Argiro: put ghost'ed front end on.
#

set path = ( . $KHOROS_HOME/bin $path /usr/local/bin /usr/ucb \
    /usr/bin /bin /usr/local/etc/ /usr/etc /etc )

if (! $?KHOROS_HOME ) then
   echo ""
   echo "Error KHOROS_HOME environment variable is not set"
   echo ""
   exit 0
endif

onintr cleanup

set PWD = `pwd`
set tmac = $KHOROS_HOME/man/utils/tmac/tmac.anc

##### initialize variables #####

set TEMPDIR = /tmp 

##### get arguments off the command line #####

set TYPE_FILE = $argv[1]
set NAME_PROG = $argv[2]

switch ($TYPE_FILE)
   case doc:
	set file = `basename $NAME_PROG .doc`
	if (-e $file.doc) then
  	  echo ".pl 130i" > $TEMPDIR/$file.$$.doc
  	  echo ".nr LL 6" >> $TEMPDIR/$file.$$.doc
  	  cat $file.doc >> $TEMPDIR/$file.$$.doc
  	  if ($TEMPDIR != ".") then
    	    mv $TEMPDIR/$file.$$.doc $file.$$.doc
  	  endif
	  cat $KHOROS_HOME/repos/utils/online.cpright >> $file.$$.doc
  	  echo -n "Formatting file: $file ... "
  	  nroff $tmac $file.$$.doc > $file.$$
  	  cat -s $file.$$ | sed -e "s|.||g" > $file
  	  echo "done."
  	  /bin/rm -f $file.$$
  	  /bin/rm -f $file.$$.doc
        else
            echo "formatdoc: can not find file '$file'"
        endif
        breaksw
   case alldoc:
        foreach docfile (*.doc)
	   set file = `basename $docfile .doc`
	   if (-e $file.doc) then
  	     echo ".pl 130i" > $TEMPDIR/$file.$$.doc
  	     echo ".nr LL 6" >> $TEMPDIR/$file.$$.doc
  	     cat $file.doc >> $TEMPDIR/$file.$$.doc
  	     if ($TEMPDIR != ".") then
    	       mv $TEMPDIR/$file.$$.doc $file.$$.doc
  	     endif
	     cat $KHOROS_HOME/repos/utils/online.cpright >> $file.$$.doc
  	     echo -n "Formatting file: $file ... "
  	     nroff $tmac $file.$$.doc > $file.$$
  	     cat -s $file.$$ | sed -e "s|.||g" > $file
  	     echo "done."
  	     /bin/rm -f $file.$$
  	     /bin/rm -f $file.$$.doc
           else
               echo "formatdoc: can not find file '$file'"
           endif
        end
        breaksw
   case help:
        if ( -e help && -d help) then
	   set file = `basename $NAME_PROG .doc`
	   if (-e $file.doc) then
  	     echo ".pl 130i" > $TEMPDIR/$file.$$.doc
  	     echo ".nr LL 6" >> $TEMPDIR/$file.$$.doc
  	     cat $file.doc >> $TEMPDIR/$file.$$.doc
  	     if ($TEMPDIR != ".") then
    	       mv $TEMPDIR/$file.$$.doc $file.$$.doc
  	     endif
	     cat $KHOROS_HOME/repos/utils/online.cpright >> $file.$$.doc
  	     echo -n "Converting file: $file ... "
  	     nroff $tmac $file.$$.doc > $file.$$
  	     cat -s $file.$$ | sed -e "s|.||g" > help/$file
  	     echo "done."
  	     /bin/rm -f $file.$$
  	     /bin/rm -f $file.$$.doc
           else
               echo "formatdoc: can not find file '$file'"
           endif
        else
            echo "formatdoc: help directory does not exit"
        endif
        breaksw
   case allhelp:
        if ( -e help && -d help) then
           foreach docfile (*.doc)
	      set file = `basename $docfile .doc`
	      if (-e $file.doc) then
  	        echo ".pl 130i" > $TEMPDIR/$file.$$.doc
  	        echo ".nr LL 6" >> $TEMPDIR/$file.$$.doc
  	        cat $file.doc >> $TEMPDIR/$file.$$.doc
  	        if ($TEMPDIR != ".") then
    	          mv $TEMPDIR/$file.$$.doc $file.$$.doc
  	        endif
	        cat $KHOROS_HOME/repos/utils/online.cpright >> $file.$$.doc
  	        echo -n "Formatting file: $file ... "
  	        nroff $tmac $file.$$.doc > $file.$$
  	        cat -s $file.$$ | sed -e "s|.||g" > help/$file
  	        echo "done."
  	        /bin/rm -f $file.$$
  	        /bin/rm -f $file.$$.doc
              else
                  echo "formatdoc: can not find file '$file'"
              endif
           end
        else
            echo "formatdoc: help directory does not exit"
        endif
        breaksw
        
   default:
        echo "invalid type"
        breaksw
endsw

exit 0


cleanup:
    if (-e $file.$$) then
  	  /bin/rm -f $file.$$
    endif
    if (-e  $file.$$.doc) then
  	  /bin/rm -f $file.$$.doc
    endif
    exit 0
