 /*
  * Khoros: $Id: lvarviff.c,v 1.1 1991/05/10 15:41:54 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lvarviff.c,v 1.1 1991/05/10 15:41:54 khoros Exp $";
#endif

 /*
  * $Log: lvarviff.c,v $
 * Revision 1.1  1991/05/10  15:41:54  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lvarviff.c
 >>>>
 >>>>      Program Name: varviff
 >>>>
 >>>> Date Last Updated: Fri Mar 22 14:36:53 1991 
 >>>>
 >>>>          Routines: lvarviff - the library call for varviff
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lvarviff - library call for varviff
*
* Purpose:
*    
*    Extracts a single data value from a viff structure  for  the
*    cantata parser.
*    
*    
* Input:
*    
*    image          xvimage structure
*    
*    x              value location in x direction (column index)
*    
*    y              value location in y direction (row index)
*    
*    band           band number of value
*    
*                   Note that indexing begins at zero (0).
*    
*    
* Output:
*    
*    value          single data element of pixel value.
*    
*    Return Value:  1 on success, 0 on failure.
*    
*    
*
* Written By: John Rasure and Carla Williams
*    
*    
****************************************************************/


/* -library_def */
int
lvarviff(image,x,y,band,value)
struct xvimage *image;
int     x,y,band;
double  *value;
/* -library_def_end */

/* -library_code */
{
    unsigned char        *c;     /* pointer for byte data type */
    int         *i;     /* pointer for integer data type */
    short       *s;     /* pointer for short data type */
    float       *f;     /* pointer for float data type */
    double       *d;     /* pointer for double data type */

    if ( band < 0 || band > image->num_data_bands) {
        (void) fprintf(stderr,"lvarviff: The specified band is out of range.  Specified value = %d, number of bands in image = %d.\n", band, image->num_data_bands);
        return(0);
    }

    if ( x < 0 || x > image->row_size) {
        (void) fprintf(stderr,"lvarviff: The specified x index is out of range.  Specified value = %d, number of columns in image = %d.\n", x, image->row_size);
        return(0);
    }

    if ( y < 0 || y > image->col_size) {
        (void) fprintf(stderr,"lvarviff: The specified y index is out of range.  Specified value = %d, number of rows in image = %d.\n", y, image->col_size);
        return(0);
    }

    switch (image->data_storage_type)
        {
            case VFF_TYP_BIT :
                (void) fprintf(stderr,"lvarviff: Don't know how to extract BIT values\n");
                return(0);
                break;

            case VFF_TYP_1_BYTE :
                c = (unsigned char *)(image->imagedata);
                *value = *(c + (image->row_size*image->col_size*band) +
                             (image->row_size*y +x));
                break;

            case VFF_TYP_2_BYTE :
                s = (short *)(image->imagedata);
                *value = *(s + (image->row_size*image->col_size*band) +
                             (image->row_size*y +x));
                break;

            case VFF_TYP_4_BYTE :
                i = (int *)(image->imagedata);
                *value = *(i + (image->row_size*image->col_size*band) +
                             (image->row_size*y +x));
                break;

            case VFF_TYP_FLOAT :
                f = (float *)(image->imagedata);
                *value = *(f + (image->row_size*image->col_size*band) +
                             (image->row_size*y +x));
                break;

            case VFF_TYP_DOUBLE :
                d = (double *)(image->imagedata);
                *value = *(d + (image->row_size*image->col_size*band) +
                             (image->row_size*y +x));
                break;

            case VFF_TYP_COMPLEX :
            case VFF_TYP_DCOMPLEX :
                (void) fprintf(stderr,"lvarviff: Don't know how to extract COMPLEX values\n");
                return(0);
                break;

            default:
                (void) fprintf(stderr,"lvarviff: Unknown data storage type, %d\n", image->data_storage_type);
                return(0);
                break;
        }
    return(1);
}
/* -library_code_end */
