 /*
  * Khoros: $Id: lvhsee.c,v 1.1 1991/05/10 15:41:54 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lvhsee.c,v 1.1 1991/05/10 15:41:54 khoros Exp $";
#endif

 /*
  * $Log: lvhsee.c,v $
 * Revision 1.1  1991/05/10  15:41:54  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lvhsee.c
 >>>>
 >>>>      Program Name: vhsee
 >>>>
 >>>> Date Last Updated: Tue Mar  5 22:33:13 1991 
 >>>>
 >>>>          Routines: lvhsee - the library call for vhsee
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lvhsee - library call for vhsee
*
* Purpose:
*    
*    Determine a visible histogram of the gray-levels in  a  byte
*    type image.
*    
*    
* Input:
*    
*         image --  the image in which to calcualte the histogram
*                   from.  pneg  --  an integer flag indicating if
*                   the image is to be inverted.  plot  --  an integer
*         indicating if the output should be
*                   displayed (0) or stored to a viff file (1).
*    
*    
* Output:
*    
*         image --  an khoros Byte image to hold the histogram.
*    
*         The output data type is the same as the input data type.
*    
*         both routines return 1 upon success and 0 on failure.
*    
*    
*
* Written By: Mark Young, Marcelo Teran, Ramiro Jordan
*    
*    Marcelo Teran, Mark Young, Ramiro Jordan John Rasure Sat Mar
*    25  15:47:45  MST  1989  To update to the new xviff - pff no
*    longer exists.
*    
*    
****************************************************************/


/* -library_def */
int
lvhsee (in_image, out_image, pneg, pff)
struct xvimage *in_image, **out_image;
int  pneg, pff;
/* -library_def_end */

/* -library_code */
{
    int i, j, max;
    float f, *s;
    unsigned int hist[256];
    unsigned char *p;
    struct xvimage *createimage(), *tempimage;

    if (pff == 0) {

        /* Form histogram */
        bzero(hist,256*sizeof(int));
        p = (unsigned char *)(in_image->imagedata);
        for (i=0; i<in_image->row_size*in_image->col_size; i++) hist[*p++]++;

        max = 0;
        for (i = 0; i < 256; i++) if (max < hist[i]) max = hist[i];

        /*
         * compute the scale factor in order to scale the image to be with
         * in 0 to 255 pixels (the height of the image).
         */
        f = (float) 255.0/max;

        /* a viewable viff image is the output desired */
        tempimage = createimage (256, 256, VFF_TYP_1_BYTE, 1, 
                                1, "histogram created by vhsee", 0, 0,
                                VFF_MS_NONE, VFF_MAPTYP_NONE, 
                                VFF_LOC_IMPLICIT, 0);
        if (tempimage == NULL) {
            fprintf (stderr, "error in lvhsee - not enough memory\n");
            return (0);
        }

        /* Set the picture to black */
        p = (unsigned char *)(tempimage->imagedata);
        for (i = 0; i < 256*256; i++) *p++ = 0; /* Set to black */

        /* Draw the lines (white = 255) */
        for (i = 0; i < 256; i++)
        {
            p = (unsigned char *)(tempimage->imagedata) + 255*256 +i;
            for (j = 0; j < f*hist[i]; j++)
            {
                *p = 255;
                 p -= 256;
            }
        }

        /* Make black on white if requested */
        p = (unsigned char *)(tempimage->imagedata);
        if (pneg) for (i=0; i<256*256; i++) p[i] = 255 - p[i];

        *out_image = tempimage;
        return(1);
    }

    else {

        bzero(hist,sizeof(unsigned int)*256);
        p = (unsigned char *)(in_image->imagedata);
        for (i=0; i<in_image->row_size*in_image->col_size; i++) hist[*p++]++;

        /* a plotable viff image is the output desired */
        tempimage = createimage (1, 256, VFF_TYP_FLOAT, 1,
                             1, "histogram created by vhsee", 0, 0,
                             VFF_MS_NONE, VFF_MAPTYP_NONE,
                             VFF_LOC_IMPLICIT, 0);
        if (tempimage == NULL )
        {
            fprintf (stderr, "error in lvhsee - not enough memory\n");
            return (0);
        }

        /* Copy the histogram data into the image */
        s = (float *)(tempimage->imagedata);

        for (i = 0; i < 256; i++) *s++ = (float) hist[i] ; 

        *out_image = tempimage;
        return(1);
    }
}
/* -library_code_end */
