 /*
  * Khoros: $Id: lvthresh.c,v 1.1 1991/05/10 15:41:54 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lvthresh.c,v 1.1 1991/05/10 15:41:54 khoros Exp $";
#endif

 /*
  * $Log: lvthresh.c,v $
 * Revision 1.1  1991/05/10  15:41:54  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lvthresh.c
 >>>>
 >>>>      Program Name: vthresh
 >>>>
 >>>> Date Last Updated: Thu Mar 28 00:11:44 1991 
 >>>>
 >>>>          Routines: lvthresh - the library call for vthresh
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lvthresh - library call for vthresh
*
* Purpose:
*    
*    Create a binary image by applying upper and lower thresholds
*    to an input image.
*    
*    
* Input:
*    
*    image          points to the input xvimage structure
*    
*    lflag          a flag set (equal 1)  if  checking  of  the  lower
*                   bound is desired.
*    
*    uflag          a flag set (equal 1)  if  checking  of  the  upper
*                   bound is desired.
*    
*    lthresh        a lower bound level.
*    
*    uthresh        a upper bound level.
*    
*    value          a value to give to output pixels that are non-zero
*                   by thresholding.
*    
*    
* Output:
*    
*    image          points to the xvimage structure that contains  the
*                   result of the operation.
*    
*    Return Value:  1 on success, 0 on failure.
*    
*    
*
* Written By: Scott Wilson
*    
*    
****************************************************************/


/* -library_def */
int
lvthresh(image,lflag,lthresh,uflag,uthresh,value)
struct xvimage *image;
int lflag,uflag;
float lthresh,uthresh;
float value;
/* -library_def_end */

/* -library_code */
{
    int    *i,iv, j, k;
    short  *s,sv;
    float  *f,fv;
    unsigned char *c,cv;

    if  (!lflag && !uflag) lflag = 1;     /* Default is lower threshold only */

    switch (image->data_storage_type)
      {
        case VFF_TYP_BIT :
          (void) fprintf(stderr,"lvthresh: Don't know how to threshold BIT images\n");
          return(0);
          break;
        case VFF_TYP_1_BYTE : 
          k = image->row_size*image->col_size;
          c = (unsigned char *)(image->imagedata);
          for (j=0; j<k; j++)
            {
              cv = *c;
              *c = 0;
              if (lflag && !uflag && ((float)cv > lthresh)) *c = value;
              if (uflag && !lflag && ((float)cv < uthresh)) *c = value;
              if (lflag && uflag && ((float)cv > lthresh) && ((float)cv < uthresh))
                *c = value;
              if (lflag && uflag && (lthresh == uthresh) && ((float)cv == lthresh))
                *c = value;
              c++;
            }
          break;
        case VFF_TYP_2_BYTE :
          k = image->row_size*image->col_size;
          s = (short *)(image->imagedata);
          for (j=0; j<k; j++)
            {
              sv = *s;
              *s = 0;
              if (lflag && !uflag && ((float)sv > lthresh)) *s = value;
              if (uflag && !lflag && ((float)sv < uthresh)) *s = value;
              if (lflag && uflag && ((float)sv > lthresh) && ((float)sv < uthresh))
                *s = value;
              if (lflag && uflag && (lthresh == uthresh) && ((float)sv == lthresh))
                *s = value;
              s++;
            }
          break;
        case VFF_TYP_4_BYTE :
          k = image->row_size*image->col_size;
          i = (int *)(image->imagedata);
          for (j=0; j<k; j++)
            {
              iv = *i;
              *i = 0;
              if (lflag && !uflag && ((float)iv > lthresh)) *i = value;
              if (uflag && !lflag && ((float)iv < uthresh)) *i = value;
              if (lflag && uflag && ((float)iv > lthresh) && ((float)iv < uthresh))
                *i = value;
              if (lflag && uflag && (lthresh == uthresh) && ((float)iv == lthresh))
                *i = value;
              i++;
            }   
          break;
        case VFF_TYP_FLOAT :
          k = image->row_size*image->col_size;
          f = (float *)(image->imagedata);
          for (j=0; j<k; j++)
            {
              fv = *f;
              *f = 0.0;
              if (lflag && !uflag && (fv > lthresh)) *f = value;
              if (uflag && !lflag && (fv < uthresh)) *f = value;
              if (lflag && uflag && (fv > lthresh) && (fv < uthresh))
                *f = value;
              if (lflag && uflag && (lthresh == uthresh) && (fv == lthresh))
                *f = value;
              f++;
            }   
          break;
        case VFF_TYP_COMPLEX :
          k = image->row_size*image->col_size;

          f = (float *)(image->imagedata);
          for (j=0; j<k; j++)
            {
              fv =sqrt((double)((*f * *f) + (*(f+1) * *(f+1))));
              *f = 0.0; *(f+1) = 0.0;
              if (lflag && !uflag && (fv > lthresh)) *f = value;
              if (uflag && !lflag && (fv < uthresh)) *f = value;
              if (lflag && uflag && (fv > lthresh) && (fv < uthresh))
                *f = value;
              if (lflag && uflag && (lthresh == uthresh) && (fv == lthresh))
                *f = value;
              f += 2;  
            }
          break;
        default:
          (void) fprintf(stderr,"lvthresh: Unknown data storage type, %d\n",image->data_storage_type);
          return(0);
          break;
      }
      return(1);
}
/* -library_code_end */
