 /*
  * Khoros: $Id: vsqrt.c,v 1.1 1991/05/10 15:45:57 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vsqrt.c,v 1.1 1991/05/10 15:45:57 khoros Exp $";
#endif

 /*
  * $Log: vsqrt.c,v $
 * Revision 1.1  1991/05/10  15:45:57  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vsqrt.c
 >>>>
 >>>>      Program Name: vsqrt
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Compute the square root of an image pixel by pixel.
 >>>>	
 >>>>	
 >>>>            Author: Scott Wilson
 >>>>
 >>>> Date Last Updated: Wed Mar 27 23:59:53 1991
 >>>>
 >>>>          Routines: main- the main program for vsqrt
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vsqrt.h"


/****************************************************************
 *
 * Routine Name:  main program for vsqrt
 *
 *       Input:  
 *       -i  input image 
 *       -o  resulting output image 
 *
 *
 *       [-m] square root operation masking image
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
    struct xvimage *img1, *img2, *readimage();
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
    if (check_args()) exit(1);
    img1 = readimage(vsqrt->i_file);
    if (img1 == NULL) exit(1);                   /* Quit if bad image */
    if (vsqrt->m_flag) img2 = readimage(vsqrt->m_file);
    if (vsqrt->m_flag && (img2 == NULL)) exit(1);       /* Quit if bad image */

    CHECKINPUT(program,img1);   /* Verify input image */

    if(vsqrt->m_flag){
        MATCHINPUT(program,img1,img2);  /* Verify input images */
    }
/* -main_before_lib_call_end */

/* -main_library_call */
    if(! lvsqrt(img1,img2,vsqrt->m_flag) )
    {
        (void) fprintf(stderr, "lvsqrt Failed\n");
        exit(1);
    }
/* -main_library_call_end */

/* -main_after_lib_call */
    writeimage(vsqrt->o_file,img1);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vsqrt 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vsqrt :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tCompute the square root of an image pixel by pixel.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input image  (infile)\n");
	fprintf(stderr,"\t-o  resulting output image  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-m]  square root operation masking image (infile) [null]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vsqrt\n");
	fprintf(stderr, "\t[-U] Gives the usage for vsqrt\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vsqrt.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vsqrt.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vsqrt
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input image \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) resulting output image \n        {outfile}: "; 
char	*m_pstr = 
	"\nEnter: (m) square root operation masking image \n        {infile}: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vsqrt", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vsqrt.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vsqrt: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vsqrt.ans");
		}

	     }

	}

	/*
	 * allocate the vsqrt structure
	 */
	vsqrt = (vsqrt_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vsqrt_struct));

	/*
	 * get required arguments for vsqrt
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vsqrt->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(vsqrt->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vsqrt->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    vsqrt->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(vsqrt->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vsqrt->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(vsqrt->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vsqrt->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    vsqrt->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(vsqrt->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for vsqrt
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	vsqrt->m_flag = vget_infile(fid, prompt_flag,
	"-m", m_pstr, &(vsqrt->m_file))
;


}



