 /*
  * Khoros: $Id: vsubstit.c,v 1.1 1991/05/10 15:45:58 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vsubstit.c,v 1.1 1991/05/10 15:45:58 khoros Exp $";
#endif

 /*
  * $Log: vsubstit.c,v $
 * Revision 1.1  1991/05/10  15:45:58  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vsubstit.c
 >>>>
 >>>>      Program Name: vsubstit
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Substitute each occurrence of a pixel value in an image with
 >>>>	a different value
 >>>>	
 >>>>	
 >>>>            Author: Greg Donohoe
 >>>>
 >>>> Date Last Updated: Tue Mar  5 22:19:46 1991
 >>>>
 >>>>          Routines: main- the main program for vsubstit
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vsubstit.h"


/****************************************************************
 *
 * Routine Name:  main program for vsubstit
 *
 *       Input:  
 *          -i  input image 
 *          -o  output image 
 *          -old  replaced value   (0 < value < 255)
 *          -new  replacement value   (0 < value < 255)
 *
 *
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
    struct xvimage *image, *readimage();
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
    if (check_args()) exit(1);
    image = readimage(vsubstit->i_file);
    CHECKINPUT(program, image);
/* -main_before_lib_call_end */

/* -main_library_call */
    if(! lvsubstit(image,vsubstit->old_int,vsubstit->new_int))
    {
        (void) fprintf(stderr, "vsubstit: lvsubstit Failed\n");
        exit(1);
    }
/* -main_library_call_end */

/* -main_after_lib_call */
    writeimage(vsubstit->o_file,image);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vsubstit 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vsubstit :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tSubstitute each occurrence of a pixel value in an image with\n");
	fprintf(stderr, "\ta different value\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input image  (infile)\n");
	fprintf(stderr,"\t-o  output image  (outfile)\n");
	fprintf(stderr,"\t-old  replaced value  (integer, 0 to 255)\n");
	fprintf(stderr,"\t-new  replacement value  (integer, 0 to 255)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vsubstit\n");
	fprintf(stderr, "\t[-U] Gives the usage for vsubstit\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vsubstit.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vsubstit.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vsubstit
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input image \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) output image \n        {outfile}: "; 
char	*old_pstr = 
	"\nEnter: (old) replaced value \n        {integer, 0 to 255}: "; 
char	*new_pstr = 
	"\nEnter: (new) replacement value \n        {integer, 0 to 255}: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vsubstit", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vsubstit.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vsubstit: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vsubstit.ans");
		}

	     }

	}

	/*
	 * allocate the vsubstit structure
	 */
	vsubstit = (vsubstit_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vsubstit_struct));

	/*
	 * get required arguments for vsubstit
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vsubstit->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(vsubstit->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vsubstit->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    vsubstit->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(vsubstit->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vsubstit->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(vsubstit->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vsubstit->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    vsubstit->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(vsubstit->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vsubstit->old_flag = vget_int(fid, prompt_flag,
			"-old", old_pstr, &(vsubstit->old_int),
			0, 0, 255)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vsubstit->old_flag))
		{
		    fprintf(stderr, "\t\told is required, please re-enter: \n");
		    vsubstit->old_flag = vget_int(fid, prompt_flag,
		    "-old", old_pstr, &(vsubstit->old_int),
		    0, 0, 255);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-old' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vsubstit->new_flag = vget_int(fid, prompt_flag,
			"-new", new_pstr, &(vsubstit->new_int),
			0, 0, 255)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vsubstit->new_flag))
		{
		    fprintf(stderr, "\t\tnew is required, please re-enter: \n");
		    vsubstit->new_flag = vget_int(fid, prompt_flag,
		    "-new", new_pstr, &(vsubstit->new_int),
		    0, 0, 255);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-new' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}


}



