 /*
  * Khoros: $Id: viso2.c,v 1.2 1992/03/20 23:13:03 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: viso2.c,v 1.2 1992/03/20 23:13:03 dkhoros Exp $";
#endif

 /*
  * $Log: viso2.c,v $
 * Revision 1.2  1992/03/20  23:13:03  dkhoros
 * VirtualPatch5
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: viso2.c
 >>>>
 >>>>      Program Name: viso2
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Performs the ISO2 clustering algorithm on an image.
 >>>>	
 >>>>	
 >>>>            Author: Tom Sauer, Donna Koechner
 >>>>
 >>>> Date Last Updated: Tue Mar  5 22:20:33 1991
 >>>>
 >>>>          Routines: main- the main program for viso2
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "viso2.h"


/****************************************************************
 *
 * Routine Name:  main program for viso2
 *
 *       Input:  
 *       -i1  input image 
 *       -o1  output image specifying which vector belongs to what cluster 
 *       -o2  output image for cluster centers 
 *       -o3  output variance 
 *
 *
 *       [-f2] output file for kmeans statistics
 *       [-n] specifies minimum number of samples per cluster (default = 1)  (value >= 0)
 *       [-s] specifies splitting factor (splitting factor increase -> less splitting) (default = 10000000)  (value >= 0.0)
 *       [-m] specifies merging factor (merging factor decreases -> less merging) (default = 0)  (value >= 0.0)
 *       [-sc] specifies splitting convergence (default = 0)  (value >= 0.0)
 *       [-mc] specifies merging convergence (default = 0)  (value >= 0.0)
 *       [-p] specifies placement of new cluster centers during splitting (default = 0.5)  (0.000 < value < 1.000)
 *       [-ik] specifies maximum number of iterations for kmeans (default = 100000)  (value > 0)
 *       [-ii] specifies maximum number of iterations for iso2 (default = 100000)  (value > 0)
 *       [-k] specifies maximum number of clusters (default = 50)  (value > 0)
 *       [-b]  specifies the border width in pixels (default = 0)  (value >= 0)
 *
 *       [-c  use First K Vectors As Cluster Centers (default = 5)    (3 < value < 1000000) -OR-
 *        -f1  input ASCII file for x-y coordinates of cluster centers  -OR-
 *        -i2  input image cluster center values   ]
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
/*MAIN_ARGS*/
    struct xvimage *image,
                   *outcc_img,
                   *cc_img,
                   *readimage (), *createimage ();
    struct xvimage *var_image;    
    FILE * input_ascii_file, *printdev2;
    int   **init_cluster,
            points;
    int     i,
            x,
            y,
            im_size;
    float  *input_ascii,
           *xy_points,
           *read_ascii ();
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
if (check_args ()) exit(1);
/* -main_before_lib_call_end */

/* -main_library_call */
cc_img = NULL;
outcc_img = NULL;
var_image = NULL;

READINPUT (image);
CHECKINPUT (program, image);

/* Allocate space for initial cluster centers
* Actually malloc space for the maximum number of clusters
*/
    init_cluster = (int **) malloc (viso2 -> k_int * sizeof (int *));
    if (init_cluster == NULL) {
        (void) fprintf (stderr,
                "viso2: No space for init_clusters - malloc failed!\n");
        exit (1);
    }

/* Allocate space for the x and y pixel location */

    for (i = 0; i < viso2 -> k_int; i++) {
        init_cluster[i] = (int *) malloc (sizeof (int) * 2);
        if (init_cluster[i] == NULL) {
            (void) fprintf (stderr, "viso2: No space for image - malloc failed!\n");
            exit (1);
        }
    }

/* check to make sure the user has not entered more clusters
than there are vectors */

    im_size = (image -> row_size - (2 * viso2 -> b_int)) * (image -> col_size - (2 * viso2 -> b_int));
    if (viso2 -> k_int > im_size) {
        (void) fprintf (stderr, "viso2: Too many clusters\n");
        (void) fprintf (stderr, "viso2: Requested number of clusters = %d\n", viso2 -> k_int);
        (void) fprintf (stderr, "viso2: Maximum number of clusters = %d\n", im_size);
        exit (1);
    }

/* Read in cluster center image as input for initial cluster centers */

    if (viso2 -> i2_flag) {
        cc_img = readimage (viso2 -> i2_file);
        if (cc_img == NULL) {
            (void) fprintf (stderr, "viso2: Cluster Center Image could not be read\n");
            exit (1);
        }

/* Make sure number of bands in cluster center image matches the
the number of bands in the input image.  */

        CHECKINPUT (program, cc_img);
        (void) match_num_bands (program, image, cc_img, TRUE);

/* Check number of cluster centers in cluster center image against
the number of desired clusters, and inform user of mismatch. */

        if ((cc_img -> row_size * cc_img -> col_size) > viso2 -> k_int) {
            (void) fprintf (stderr, "viso2: Number of Cluster Centers in Cluster Center Image\n");
            (void) fprintf (stderr, "cannot be greater than max number of clusters.\n");
            (void) fprintf (stderr, "viso2: Number of Cluster Centers in Cluster Center Image = %d\n", cc_img -> row_size * cc_img -> col_size);
            (void) fprintf (stderr, "Maximum Number of Clusters = %d\n", viso2->k_int);
            exit (1);
        }
    }
    else
        if (viso2 -> f1_flag) {  /* user specified cluster center positions */
            if (!vread_ascii (viso2 -> f1_file, &input_ascii_file)) {
                (void) fprintf (stderr, "viso2: Can't open ascii input file:\n");
                exit (1);
            }

            input_ascii = read_ascii (input_ascii_file, &points);

            points /= 2;
            if (points > viso2 -> k_int) {
                (void) fprintf (stderr, "viso2: Number of  XY pairs in %s \n", viso2 -> f1_file);
                (void) fprintf (stderr, "cannot be greater than max number of clusters.\n");
                (void) fprintf (stderr, "viso2: Number of XY pairs = %d\n", points);
                (void) fprintf (stderr, "Maximum Number of Clusters = %d\n", viso2 -> k_int);
                exit (1);
            }

            xy_points = input_ascii;
            for (i = 0; i < points; i++) {
                init_cluster[i][0] = (int) * xy_points;
                xy_points++;

/* check to make sure the x-y coordinate is inside the borders */

                if (init_cluster[i][0] < viso2 -> b_int || init_cluster[i][0] > (image -> row_size - viso2 -> b_int)) {
                    (void) fprintf (stderr, "viso2: x-coordinate in 'file' %s, line %d is out of range\n", viso2 -> f1_file, i);
                    exit (1);
                }

                init_cluster[i][1] = (int) input_ascii[i + 1];
                xy_points++;
/* check to make sure the x-y coordinate is inside the borders */
                if (init_cluster[i][1] < viso2 -> b_int || init_cluster[i][1] > (image -> col_size - viso2 -> b_int)) {
                    (void) fprintf (stderr, "viso2: y-coordinate in 'file' %s, line %d is out of range\n", viso2 -> f1_file, i);
                    exit (1);
                }
            }

            fclose (input_ascii_file);
        }
        else {             /* use first K vectors as initial cluster centers */
            if (viso2 -> c_int > viso2 -> k_int) {
                (void) fprintf (stderr, "viso2: Number of Inital Cluster Centers cannot be greater\n");
                (void) fprintf (stderr, "than Max Number of Clusters.\n");
                (void) fprintf (stderr, "viso2: Number of Inital Cluster Centers = %d\n", cc_img -> row_size * cc_img -> col_size);
                (void) fprintf (stderr, "Maximum Number of Clusters = %d\n", viso2 -> k_int);
                exit (1);
            }
            x = viso2 -> b_int;
            y = viso2 -> b_int;
            for (i = 0; i < viso2 -> c_int; i++) {
                init_cluster[i][0] = x++;
                init_cluster[i][1] = y;
                if (x == image -> row_size - viso2 -> b_int) {
                    x = viso2 -> b_int;
                    y += 1;
                }
            }
        }

/* Open file for ISO2 statistics */

    if (viso2 -> f2_flag) {
        if (!vwrite_ascii (viso2 -> f2_file, &printdev2)) {
            (void) fprintf (stderr, "viso2:  Can't open ascii output file: \n");
            exit (1);
        }
    }
    else
        printdev2 = stdout;

/* Call the lib routine for the viso2 algorithm */

if (!lviso2 (image, &outcc_img, &var_image, viso2->n_int, viso2->k_int, viso2->c_int, viso2->s_float, viso2->m_float, viso2->p_float, viso2->sc_float, viso2->mc_float, viso2->ii_int, viso2->ik_int, viso2->b_int, init_cluster, viso2->i2_flag, cc_img, printdev2)) 
   {      /* stats print device          */
     (void) fprintf (stderr, "lviso2 Failed\n");
     exit (1);
   }
/* -main_library_call_end */

/* -main_after_lib_call */
/* write out the cluster center image and the cluster image */
    writeimage (viso2 -> o1_file, image);
    writeimage (viso2 -> o2_file, outcc_img);
    writeimage (viso2 -> o3_file, var_image);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for viso2 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "viso2 :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tPerforms the ISO2 clustering algorithm on an image.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i1  input image  (infile)\n");
	fprintf(stderr,"\t-o1  output image specifying which vector belongs to what cluster  (outfile)\n");
	fprintf(stderr,"\t-o2  output image for cluster centers  (outfile)\n");
	fprintf(stderr,"\t-o3  output variance  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-f2]  output file for kmeans statistics (outfile) [null]\n");
	fprintf(stderr,"\t[-n]  specifies minimum number of samples per cluster (default = 1) (integer, >= 0) [1]\n");
	fprintf(stderr,"\t[-s]  specifies splitting factor (splitting factor increase -> less splitting) (default = 10000000) (float, >= 0.0) [1e+07]\n");
	fprintf(stderr,"\t[-m]  specifies merging factor (merging factor decreases -> less merging) (default = 0) (float, >= 0.0) [0]\n");
	fprintf(stderr,"\t[-sc]  specifies splitting convergence (default = 0) (float, >= 0.0) [0]\n");
	fprintf(stderr,"\t[-mc]  specifies merging convergence (default = 0) (float, >= 0.0) [0]\n");
	fprintf(stderr,"\t[-p]  specifies placement of new cluster centers during splitting (default = 0.5) (float,  0.000 to 1.000) [0.5]\n");
	fprintf(stderr,"\t[-ik]  specifies maximum number of iterations for kmeans (default = 100000) (integer, > 0) [100000]\n");
	fprintf(stderr,"\t[-ii]  specifies maximum number of iterations for iso2 (default = 100000) (integer, > 0) [100000]\n");
	fprintf(stderr,"\t[-k]  specifies maximum number of clusters (default = 50) (integer, > 0) [50]\n");
	fprintf(stderr,"\t[-b]   specifies the border width in pixels (default = 0) (integer, >= 0) [0]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\t[ ");
	fprintf(stderr,"-c  use First K Vectors As Cluster Centers (default = 5)  (integer, 3 to 1000000) -OR- \n");
	fprintf(stderr,"\t  -f1  input ASCII file for x-y coordinates of cluster centers  (infile) -OR- \n");
	fprintf(stderr,"\t  -i2  input image cluster center values  (infile) ]\n\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for viso2\n");
	fprintf(stderr, "\t[-U] Gives the usage for viso2\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called viso2.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses viso2.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for viso2
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i1_pstr = 
	"\nEnter: (i1) input image \n        {infile}: "; 
char	*o1_pstr = 
	"\nEnter: (o1) output image specifying which vector belongs to what cluster \n        {outfile}: "; 
char	*o2_pstr = 
	"\nEnter: (o2) output image for cluster centers \n        {outfile}: "; 
char	*o3_pstr = 
	"\nEnter: (o3) output variance \n        {outfile}: "; 
char	*f2_pstr = 
	"\nEnter: (f2) output file for kmeans statistics \n        {outfile}: "; 
char	*n_pstr = 
	"\nEnter: (n) specifies minimum number of samples per cluster (default = 1) \n        {integer, >= 0 [1] }: "; 
char	*s_pstr = 
	"\nEnter: (s) specifies splitting factor (splitting factor increase -> less splitting) (default = 10000000) \n        {float, >= 0.0 [10000000.000000] }: "; 
char	*m_pstr = 
	"\nEnter: (m) specifies merging factor (merging factor decreases -> less merging) (default = 0) \n        {float, >= 0.0 [0.000000] }: "; 
char	*sc_pstr = 
	"\nEnter: (sc) specifies splitting convergence (default = 0) \n        {float, >= 0.0 [0.000000] }: "; 
char	*mc_pstr = 
	"\nEnter: (mc) specifies merging convergence (default = 0) \n        {float, >= 0.0 [0.000000] }: "; 
char	*p_pstr = 
	"\nEnter: (p) specifies placement of new cluster centers during splitting (default = 0.5) \n        {float,  0.000 to 1.000 [0.500000] }: "; 
char	*ik_pstr = 
	"\nEnter: (ik) specifies maximum number of iterations for kmeans (default = 100000) \n        {integer, > 0 [100000] }: "; 
char	*ii_pstr = 
	"\nEnter: (ii) specifies maximum number of iterations for iso2 (default = 100000) \n        {integer, > 0 [100000] }: "; 
char	*k_pstr = 
	"\nEnter: (k) specifies maximum number of clusters (default = 50) \n        {integer, > 0 [50] }: "; 
char	*b_pstr = 
	"\nEnter: (b)  specifies the border width in pixels (default = 0) \n        {integer, >= 0 [0] }: "; 
char	*c_pstr = 
	"\nEnter: (c) use First K Vectors As Cluster Centers (default = 5) \n        {integer, 3 to 1000000 [5] }: "; 
char	*f1_pstr = 
	"\nEnter: (f1) input ASCII file for x-y coordinates of cluster centers \n        {infile}: "; 
char	*i2_pstr = 
	"\nEnter: (i2) input image cluster center values \n        {infile}: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "viso2", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "viso2.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "viso2: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "viso2.ans");
		}

	     }

	}

	/*
	 * allocate the viso2 structure
	 */
	viso2 = (viso2_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (viso2_struct));

	/*
	 * get required arguments for viso2
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(viso2->i1_flag = vget_infile(fid, prompt_flag,
			"-i1", i1_pstr, &(viso2->i1_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(viso2->i1_flag))
		{
		    fprintf(stderr, "\t\ti1 is required, please re-enter: \n");
		    viso2->i1_flag = vget_infile(fid, prompt_flag,
		    "-i1", i1_pstr, &(viso2->i1_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i1' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(viso2->o1_flag = vget_outfile(fid, prompt_flag,
			"-o1", o1_pstr, &(viso2->o1_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(viso2->o1_flag))
		{
		    fprintf(stderr, "\t\to1 is required, please re-enter: \n");
		    viso2->o1_flag = vget_outfile(fid, prompt_flag,
		    "-o1", o1_pstr, &(viso2->o1_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o1' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(viso2->o2_flag = vget_outfile(fid, prompt_flag,
			"-o2", o2_pstr, &(viso2->o2_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(viso2->o2_flag))
		{
		    fprintf(stderr, "\t\to2 is required, please re-enter: \n");
		    viso2->o2_flag = vget_outfile(fid, prompt_flag,
		    "-o2", o2_pstr, &(viso2->o2_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o2' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(viso2->o3_flag = vget_outfile(fid, prompt_flag,
			"-o3", o3_pstr, &(viso2->o3_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(viso2->o3_flag))
		{
		    fprintf(stderr, "\t\to3 is required, please re-enter: \n");
		    viso2->o3_flag = vget_outfile(fid, prompt_flag,
		    "-o3", o3_pstr, &(viso2->o3_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o3' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for viso2
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	viso2->f2_flag = vget_outfile(fid, prompt_flag,
	"-f2", f2_pstr, &(viso2->f2_file))
;

	viso2->n_flag = vget_int(fid, prompt_flag,
	"-n", n_pstr, &(viso2->n_int),
	1, 1, 1);

	viso2->s_flag = vget_float(fid, prompt_flag,
	"-s", s_pstr, &(viso2->s_float),
	10000000.000000, 1.000000, 1.000000);

	viso2->m_flag = vget_float(fid, prompt_flag,
	"-m", m_pstr, &(viso2->m_float),
	0.000000, 1.000000, 1.000000);

	viso2->sc_flag = vget_float(fid, prompt_flag,
	"-sc", sc_pstr, &(viso2->sc_float),
	0.000000, 1.000000, 1.000000);

	viso2->mc_flag = vget_float(fid, prompt_flag,
	"-mc", mc_pstr, &(viso2->mc_float),
	0.000000, 1.000000, 1.000000);

	viso2->p_flag = vget_float(fid, prompt_flag,
	"-p", p_pstr, &(viso2->p_float),
	0.500000, 0.000000, 1.000000);

	viso2->ik_flag = vget_int(fid, prompt_flag,
	"-ik", ik_pstr, &(viso2->ik_int),
	100000, 2, 2);

	viso2->ii_flag = vget_int(fid, prompt_flag,
	"-ii", ii_pstr, &(viso2->ii_int),
	100000, 2, 2);

	viso2->k_flag = vget_int(fid, prompt_flag,
	"-k", k_pstr, &(viso2->k_int),
	50, 2, 2);

	viso2->b_flag = vget_int(fid, prompt_flag,
	"-b", b_pstr, &(viso2->b_int),
	0, 1, 1);

	/*
	 * get optional mutually exclusive groups for viso2
	 */
	if (prompt_flag == TRUE)
	{
		   fprintf(stderr, "\nThe following prompts are mutually exclusive.\n");
		   fprintf(stderr, "\nHit <cr> until the desired prompt appears.\n");
		viso2->c_flag = vget_int(fid, prompt_flag,
		    "-c", c_pstr, &(viso2->c_int),
		    5, 3, 1000000);

    		if(!( (viso2->c_flag)))
		    viso2->f1_flag = vget_infile(fid, prompt_flag,
		    "-f1", f1_pstr, &(viso2->f1_file))
;

    		if(!( (viso2->c_flag)|| 
		     (viso2->f1_flag)))
		    viso2->i2_flag = vget_infile(fid, prompt_flag,
		    "-i2", i2_pstr, &(viso2->i2_file))
;

		   fprintf(stderr, "\n ------\n");
	}
	else
	{
		count = 0;
		if(viso2->c_flag = vget_int(fid, prompt_flag,
		    "-c", c_pstr, &(viso2->c_int),
		    5, 3, 1000000))
		    count++;

		if(viso2->f1_flag = vget_infile(fid, prompt_flag,
		    "-f1", f1_pstr, &(viso2->f1_file))
)
		    count++;

		if(viso2->i2_flag = vget_infile(fid, prompt_flag,
		    "-i2", i2_pstr, &(viso2->i2_file))
)
		    count++;

		if (count > 1)
		{
		    fprintf(stderr, "Error: You may specify ONLY ONE of :\n");
		    fprintf(stderr, " -c  -f1  -i2 \n");
		    gw_usage();
		    exit(1);
		}

	}


}



