 /*
  * Khoros: $Id: vcltrans.h,v 1.1 1991/05/10 15:46:25 khoros Exp $
  */

 /*
  * $Log: vcltrans.h,v $
 * Revision 1.1  1991/05/10  15:46:25  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vcltrans.h
 >>>>            Author: Donna Koechner, Tom Sauer
 >>>> Date Last Updated: Tue Mar  5 22:21:40 1991
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _vcltrans_h_
#define _vcltrans_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program,	/* a pointer to the program name argv[0] */
	*calloc();
int	ac;

/****************************************************************
*
*                    vcltrans Argument Structure
*
****************************************************************/

typedef struct _vcltrans  {

/*
 *  input image (Required infile)
 */
char	*i_file;	/* input image FILENAME */
int	 i_flag;	/* input image FLAG */

/*
 *  output resulting image (Required outfile)
 */
char	*o_file;	/* output resulting image FILENAME */
int	 o_flag;	/* output resulting image FLAG */

/*
 *  specifies normalization factor (Optional float)
 */
float	 n_float;	/* specifies normalization factor FLOAT */
int	 n_flag;   	/* specifies normalization factor FLAG */

/*
 * lets user chose color space model (Optional integer toggle - )
 */
int	 t_toggle;		/* lets user chose color space model INT TOGGLE */
int	 t_flag;		/* lets user chose color space model FLAG */

}  vcltrans_struct;

vcltrans_struct *vcltrans;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */
#define READINPUT(image) \
    image = readimage(vcltrans->i_file); \
    if(image == NULL){ \
        (void) fprintf(stderr,"vcltrans: Image could not be read\\n"); \
        exit(1); \
    }

#define CHECKINPUT(program, image) \
        (void) proper_num_images(program,image,1,TRUE); \
        \
        (void) proper_num_bands(program,image,3,TRUE); \
        \
        (void) proper_map_enable(program,image,VFF_MAP_OPTIONAL,TRUE); \
        \
        (void) propertype(program, image, VFF_TYP_FLOAT, FALSE)

#define CHECKCOLORMODEL(program, image) \
   if ( ! (proper_color_model(program, image, VFF_CM_ntscRGB, FALSE)) && \
       ! (proper_color_model(program, image, VFF_CM_genericRGB, FALSE)) && \
       ! (proper_color_model(program, image, VFF_CM_ntscYIQ, FALSE)) && \
       ! (proper_color_model(program, image, VFF_CM_ntscCMY, FALSE)) && \
       ! (proper_color_model(program, image, VFF_CM_cieXYZ, FALSE)) && \
       ! (proper_color_model(program, image, VFF_CM_cieUVW, FALSE))) { \
       (void) fprintf(stderr, "%s: Input image has an invalid color space model\\n",program); \
       (void) fprintf(stderr,"%s: Valid color space models are: \\n",program); \
       (void) fprintf(stderr,"%s: ntscRGB, genericRGB, ntscYIQ, ntscCMY, cieXYZ, cieUVW\\n",program); \
       exit(1); \
   }
/* -include_macros_end */

#endif
