 /*
  * Khoros: $Id: vblse.c,v 1.1 1991/05/10 15:47:46 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vblse.c,v 1.1 1991/05/10 15:47:46 khoros Exp $";
#endif

 /*
  * $Log: vblse.c,v $
 * Revision 1.1  1991/05/10  15:47:46  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vblse.c
 >>>>
 >>>>      Program Name: vblse
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Perform   band-limited   surface   extrapolation   (adaptive
 >>>>	apodization)
 >>>>	
 >>>>	
 >>>>            Author: Scott Wilson
 >>>>
 >>>> Date Last Updated: Wed Mar 27 23:45:37 1991
 >>>>
 >>>>          Routines: main- the main program for vblse
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vblse.h"


/****************************************************************
 *
 * Routine Name:  main program for vblse
 *
 *       Input:  
 *       -i  input image 
 *       -m  valid data mask image 
 *       -p  extrapolation PSF image 
 *       -o  output image 
 *
 *
 *       [-n] number of iterations  (value > 0)
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage *image,*mask,*psf;
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
        if (check_args()) exit(1);

        image = readimage(vblse->i_file);
        if (image == NULL) exit(1);                    

        mask = readimage(vblse->m_file);
        if (mask == NULL) exit(1);                    

        psf = readimage(vblse->p_file);
        if (psf == NULL) exit(1);                    

        if (image->data_storage_type != VFF_TYP_FLOAT)
          {
            fprintf(stderr,"vblse: Input image must be a FLOAT image\n");
            exit(1);
          }
        if (mask->data_storage_type != VFF_TYP_FLOAT)
          {
            fprintf(stderr,"vblse: mask image must be a FLOAT image\n");
            exit(1);
          }
/* -main_before_lib_call_end */

/* -main_library_call */
        if(! lvblse(image,mask,psf,vblse->n_int) )
        {
            (void) fprintf(stderr, "lvblse Failed\n");
            exit(1);
        }
/* -main_library_call_end */

/* -main_after_lib_call */
        (void) writeimage(vblse->o_file, image);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vblse 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vblse :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tPerform   band-limited   surface   extrapolation   (adaptive\n");
	fprintf(stderr, "\tapodization)\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input image  (infile)\n");
	fprintf(stderr,"\t-m  valid data mask image  (infile)\n");
	fprintf(stderr,"\t-p  extrapolation PSF image  (infile)\n");
	fprintf(stderr,"\t-o  output image  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-n]  number of iterations (integer, > 0) [100]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vblse\n");
	fprintf(stderr, "\t[-U] Gives the usage for vblse\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vblse.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vblse.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vblse
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input image \n        {infile}: "; 
char	*m_pstr = 
	"\nEnter: (m) valid data mask image \n        {infile}: "; 
char	*p_pstr = 
	"\nEnter: (p) extrapolation PSF image \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) output image \n        {outfile}: "; 
char	*n_pstr = 
	"\nEnter: (n) number of iterations \n        {integer, > 0 [100] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vblse", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vblse.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vblse: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vblse.ans");
		}

	     }

	}

	/*
	 * allocate the vblse structure
	 */
	vblse = (vblse_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vblse_struct));

	/*
	 * get required arguments for vblse
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vblse->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(vblse->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vblse->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    vblse->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(vblse->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vblse->m_flag = vget_infile(fid, prompt_flag,
			"-m", m_pstr, &(vblse->m_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vblse->m_flag))
		{
		    fprintf(stderr, "\t\tm is required, please re-enter: \n");
		    vblse->m_flag = vget_infile(fid, prompt_flag,
		    "-m", m_pstr, &(vblse->m_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-m' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vblse->p_flag = vget_infile(fid, prompt_flag,
			"-p", p_pstr, &(vblse->p_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vblse->p_flag))
		{
		    fprintf(stderr, "\t\tp is required, please re-enter: \n");
		    vblse->p_flag = vget_infile(fid, prompt_flag,
		    "-p", p_pstr, &(vblse->p_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-p' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vblse->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(vblse->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vblse->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    vblse->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(vblse->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for vblse
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	vblse->n_flag = vget_int(fid, prompt_flag,
	"-n", n_pstr, &(vblse->n_int),
	100, 2, 2);


}



