 /*
  * Khoros: $Id: vconvolve.c,v 1.1 1991/05/10 15:48:04 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vconvolve.c,v 1.1 1991/05/10 15:48:04 khoros Exp $";
#endif

 /*
  * $Log: vconvolve.c,v $
 * Revision 1.1  1991/05/10  15:48:04  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vconvolve.c
 >>>>
 >>>>      Program Name: vconvolve
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Compute two-dimensional convolution of a pair of images
 >>>>	
 >>>>	
 >>>>            Author: Richard Krukar
 >>>>
 >>>> Date Last Updated: Tue Mar  5 22:28:40 1991
 >>>>
 >>>>          Routines: main- the main program for vconvolve
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vconvolve.h"


/****************************************************************
 *
 * Routine Name:  main program for vconvolve
 *
 *       Input:  
 *           -i1  first input image 
 *           -i2  second input image (filter kernel) 
 *           -o  resulting output image 
 *
 *
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
        struct xvimage *img1,*img2,*readimage();
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
    if (check_args()) exit(1);
    img1 = readimage(vconvolve->i1_file);
    if(img1 == NULL) exit(1);            /* quit if bad image */
    img2 = readimage(vconvolve->i2_file);
    if(img2 == NULL) exit(1);            /* quit if bad image */

    CHECKINPUT(program,img1,img2);      /* Verify input images */
/* -main_before_lib_call_end */

/* -main_library_call */
    if(! lvconvolve(img1,img2))
    {
        (void) fprintf(stderr, "lvconvolve Failed\n");
        exit(1);
    }
/* -main_library_call_end */

/* -main_after_lib_call */
    writeimage(vconvolve->o_file,img1);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vconvolve 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vconvolve :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tCompute two-dimensional convolution of a pair of images\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i1  first input image  (infile)\n");
	fprintf(stderr,"\t-i2  second input image (filter kernel)  (infile)\n");
	fprintf(stderr,"\t-o  resulting output image  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vconvolve\n");
	fprintf(stderr, "\t[-U] Gives the usage for vconvolve\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vconvolve.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vconvolve.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vconvolve
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i1_pstr = 
	"\nEnter: (i1) first input image \n        {infile}: "; 
char	*i2_pstr = 
	"\nEnter: (i2) second input image (filter kernel) \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) resulting output image \n        {outfile}: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vconvolve", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vconvolve.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vconvolve: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vconvolve.ans");
		}

	     }

	}

	/*
	 * allocate the vconvolve structure
	 */
	vconvolve = (vconvolve_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vconvolve_struct));

	/*
	 * get required arguments for vconvolve
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vconvolve->i1_flag = vget_infile(fid, prompt_flag,
			"-i1", i1_pstr, &(vconvolve->i1_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vconvolve->i1_flag))
		{
		    fprintf(stderr, "\t\ti1 is required, please re-enter: \n");
		    vconvolve->i1_flag = vget_infile(fid, prompt_flag,
		    "-i1", i1_pstr, &(vconvolve->i1_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i1' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vconvolve->i2_flag = vget_infile(fid, prompt_flag,
			"-i2", i2_pstr, &(vconvolve->i2_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vconvolve->i2_flag))
		{
		    fprintf(stderr, "\t\ti2 is required, please re-enter: \n");
		    vconvolve->i2_flag = vget_infile(fid, prompt_flag,
		    "-i2", i2_pstr, &(vconvolve->i2_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i2' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vconvolve->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(vconvolve->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vconvolve->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    vconvolve->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(vconvolve->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}


}



