 /*
  * Khoros: $Id: vimpulse.h,v 1.2 1991/12/18 09:39:51 dkhoros Exp $
  */

 /*
  * $Log: vimpulse.h,v $
 * Revision 1.2  1991/12/18  09:39:51  dkhoros
 * HellPatch3
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vimpulse.h
 >>>>            Author: 
 >>>> Date Last Updated: Tue Dec 10 15:33:58 1991
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _vimpulse_h_
#define _vimpulse_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program;	/* a pointer to the program name argv[0] */
int	ac;

/****************************************************************
*
*                    vimpulse Argument Structure
*
****************************************************************/

typedef struct _vimpulse  {

/*
 *  resulting impulse image (Required outfile)
 */
char	*o_file;	/* resulting impulse image FILENAME */
int	 o_flag;	/* resulting impulse image FLAG */

/*
 *  trigger input (Optional infile)
 */
char	*trigger_file;	/* trigger input FILENAME */
int	 trigger_flag;	/* trigger input FLAG */

/*
 *  specifies the number of rows in the resulting image (Optional integer)
 */
int	 r_int; 	/* specifies the number of rows in the resulting image INT */
int	 r_flag;	/* specifies the number of rows in the resulting image FLAG */

/*
 *  specifies the number of columns in the resulting image (Optional integer)
 */
int	 c_int; 	/* specifies the number of columns in the resulting image INT */
int	 c_flag;	/* specifies the number of columns in the resulting image FLAG */

/*
 *  specifies the impulse spacing in the X direction (Optional integer)
 */
int	 x_int; 	/* specifies the impulse spacing in the X direction INT */
int	 x_flag;	/* specifies the impulse spacing in the X direction FLAG */

/*
 *  specifies the impulse spacing in the Y direction (Optional integer)
 */
int	 y_int; 	/* specifies the impulse spacing in the Y direction INT */
int	 y_flag;	/* specifies the impulse spacing in the Y direction FLAG */

/*
 *  specifies the number of impulses in the X direction (Optional integer)
 */
int	 n_int; 	/* specifies the number of impulses in the X direction INT */
int	 n_flag;	/* specifies the number of impulses in the X direction FLAG */

/*
 *  specifies the number of impulses in the Y direction (Optional integer)
 */
int	 m_int; 	/* specifies the number of impulses in the Y direction INT */
int	 m_flag;	/* specifies the number of impulses in the Y direction FLAG */

/*
 *  the X offset of first impulse from upper left corner of image (Optional integer)
 */
int	 u_int; 	/* the X offset of first impulse from upper left corner of image INT */
int	 u_flag;	/* the X offset of first impulse from upper left corner of image FLAG */

/*
 *  the Y offset of first impulse from upper left corner of image (Optional integer)
 */
int	 v_int; 	/* the Y offset of first impulse from upper left corner of image INT */
int	 v_flag;	/* the Y offset of first impulse from upper left corner of image FLAG */

}  vimpulse_struct;

vimpulse_struct *vimpulse;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */
/* -include_macros_end */

#endif
