 /*
  * Khoros: $Id: XImageP.h,v 1.2 1991/12/18 09:15:34 dkhoros Exp $
  */

 /*
  * $Log: XImageP.h,v $
 * Revision 1.2  1991/12/18  09:15:34  dkhoros
 * HellPatch3
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 *            Copyright 1990 University of New Mexico
 *  
 *  Permission to use, copy, modify, distribute, and sell this
 *  software and its documentation for any purpose is hereby
 *  granted without fee, provided that the above copyright
 *  notice appear in all copies and that both that copyright
 *  notice and this permission notice appear in supporting docu-
 *  mentation, and that the name of UNM not be used in advertis-
 *  ing or publicity pertaining to distribution of the software
 *  without specific, written prior permission.  UNM makes no
 *  representations about the suitability of this software for
 *  any purpose.  It is provided "as is" without express or
 *  implied warranty.
 *  
 *  UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 *  INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 *  NESS, IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 *  INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 *  RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 *  ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 *  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 *  OF THIS SOFTWARE.
 *  
 *----------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */

#ifndef _XImageP_h_
#define _XImageP_h_

#include <X11/Xaw/SimpleP.h>
#include <X11/Shell.h>
#include "XImage.h"

typedef struct _XImageClass
{
   int dummy;
} XImageClassPart;


typedef struct _XImageClassRec
{
   CoreClassPart    core_class;
   SimpleClassPart  simple_class;
   XImageClassPart  ximage_class;
} XImageClassRec;

extern  XImageClassRec xImageClassRec;


typedef struct
{
   /*  resources  */
   Visual	*visual;
   XImage	*image;
   Pixmap	pixmap;
   Pixmap	shape;
   Pixmap	clip;
   Pixmap	overlay, overlay_mask;

   int		ov_depth;
   Boolean	pan_image, pan_box, shape_parent;
   Dimension	width, max_width, min_width, pan_width, ov_width;
   Dimension	height, max_height, min_height, pan_height, ov_height;
   Dimension	xoffset;
   Dimension	yoffset;
   Pixel	foreground;
   Pixmap	current_shape;

   XtCallbackList  callbacks;

   /*  private state  */
   int		depth;
   GC		gc;
   GC		gc_mask;
   int		active;

   int	        pan_active;
   Widget	pan;
} XImagePart;


typedef struct _XImageRec
{
   CorePart	core;
   SimplePart   simple;
   XImagePart   ximage;
} XImageRec;

#endif
/* Do not add after this line */
