 /*
  * Khoros: $Id: error.c,v 1.2 1991/12/18 09:16:14 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: error.c,v 1.2 1991/12/18 09:16:14 dkhoros Exp $";
#endif

 /*
  * $Log: error.c,v $
 * Revision 1.2  1991/12/18  09:16:14  dkhoros
 * HellPatch3
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 * 
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *----------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "xvutils.h"	


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>	    	    file name: error.c                        <<<<
   >>>>                                                       <<<<
   >>>>		  Create an Error Widget		      <<<<
   >>>>                                                       <<<<
   >>>>                xvf_error_wait()			      <<<<              
   >>>>                xvf_create_error()		      <<<<              
   >>>>                xvf_error_ok()		              <<<<              
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */


/************************************************************
*
*  Routine Name:  xvf_error_wait(error,label,button1)
*
*      Purpose:   creates a error form which has to be
*		  acknowledged by the user before going on.
*                 NOTE: this routine will grab all events 
*                 while running. 
*
*        Input:   error    - error string (may contain \n for
*                            returns, widget will put in
*                            returns as it needs).
*                 label    - short label for top of warning.
*                            NULL will casue default of "ERROR".
*		  button1  - label for button.
*
*       Output:   wait to user to acknowledge message.
*
*    Called By:   the application program
*
*   Written By:   Stephanie Hallett
*
*************************************************************/
#define TEXT_WIDTH  30
#define TEXT_HEIGHT 7

int xvf_error_wait(error,label,button1)
char *error;
char *label;
char *button1;
{
   int status;

   ERROR_DONE = false;

   if (xvf_display == NULL)
   {
        fprintf(stderr, "%s\n", error);
	return(true);
   }

   status = xvf_create_error(error,label,button1);

   if (status == false)
      return(false);

   while(!ERROR_DONE)
   {
      xvf_process_event();      /* this does XtNextEvent/DispatchEvent*/
   }
   return(true);
}


/************************************************************
*
*  Routine Name:  xvf_create_error(error_string,error_label,button1)
*
*      Purpose:   Does the  actual creation of an error widget. 
*		  The error widget consists of a form widget with a 
*		  label, text, and an acknowledgement button.
*
*        Input:   error_string  - the error message 
*                 error_label   - short label for top of widget
*                                 NULL will casue default of "ERROR"
*		  button1       - label for acknowledgement button
*                                 NULL will casue default of "OK"
*
*       Output:   wait to user to acknowledge message.
*
*    Called By:   xvf_error_wait() or the application program
*
*   Written By:   Danielle Argiro Stephanie Hallett
*
*************************************************************/


int xvf_create_error(error_string,error_label,button1)
char *error_string;
char *error_label;
char *button1;
{
   Widget toplevel;	/* toplevel widget for message */
   Widget back;	        /* backplane for message */
   Widget label;	/* label describing type of message */
   Widget ok;	 	/* button to get rid of error message */
   int    i, button_width, label_width, width, height;
   char   name[MaxLength];
   char  *top_name, *cap_top_name;
   Arg    arg[25];


   /*
    * create identifying widget name
    */
   sprintf(name,"%d_error",Error_cnt);
   Error_cnt++;
   top_name = xvf_strcpy(name);
   cap_top_name = xvf_cap_first_letter(top_name);

   if (button1 == NULL)
   {
	button1 = xvf_strcpy("Ok");
	button_width = xvf_strlen(button1)+1;
   }
   else
	button_width = (xvf_strlen(button1)+1);

   if (error_label == NULL)
   {
	error_label = xvf_strcpy("Error:");
        label_width = xvf_strlen(error_label)+1;
   }
   else
	label_width = (xvf_strlen(error_label)+1);


   /* 
    *  create the error box's toplevel widget, and 
    *  add it to the list of toplevels
    *  that is used with journal playback.
    */
   i = 0;
   XtSetArg(arg[i], XtNscreen, xvf_screen); 	  i++;
   XtSetArg(arg[i], XtNargc, xvf_ac); 	          i++;
   XtSetArg(arg[i], XtNargv, xvf_av);	       	  i++; 
   XtSetArg(arg[i], XtNwinGravity, StaticGravity);i++; 
   toplevel = XtAppCreateShell(top_name,cap_top_name,
 	                       transientShellWidgetClass, xvf_display, arg, i);
   xvf_add_toplevel(toplevel);

   /* 
    * create the backplane widget 
    */
   back = XtCreateManagedWidget("error_back",
	   formWidgetClass, toplevel, NULL, 0);

   /* 
    * create the label widget 
    */
   width = TEXT_WIDTH - button_width - xvf_font_width + LEFT_MARGIN;
   if ( width < label_width) width = label_width;

   i = 0;
   XtSetArg(arg[i],XtNlabel,xvf_strcpy(error_label));		i++;
   XtSetArg(arg[i],XtNwidth, (Dimension) width*xvf_font_width);	i++;
   XtSetArg(arg[i],XtNmappedWhenManaged,True);		        i++;
   XtSetArg(arg[i],XtNborderWidth, 0);			 	i++;
   if (xvf_font != NULL)
   {
        XtSetArg(arg[i],XtNfont,xvf_font);                      i++;
   }
   label = XtCreateManagedWidget("error_wid",
      		labelWidgetClass,back,arg,i);

   /* 
    * create the text widget 
    */
   width  = MAX(TEXT_WIDTH, label_width + button_width);
   height = MAX(TEXT_HEIGHT, xvf_figure_height(error_string, width));

   i = 0;
   XtSetArg(arg[i], XtNeditType, XawtextRead);			i++;
   XtSetArg(arg[i], XtNtype,     XawAsciiString);		i++;
   XtSetArg(arg[i], XtNstring,   error_string);			i++;
   XtSetArg(arg[i], XtNwidth,    (Dimension) width*xvf_font_width);	i++;
   XtSetArg(arg[i], XtNheight,   (Dimension) height*xvf_font_height);	i++;
   XtSetArg(arg[i], XtNresize,   XawtextResizeHeight);		i++;
   XtSetArg(arg[i], XtNwrap,     XawtextWrapWord);		i++;
   XtSetArg(arg[i], XtNfromVert, label);			i++;
   XtSetArg(arg[i], XtNleftMargin,LEFT_MARGIN);			i++;
   if (xvf_font != NULL)
   {
        XtSetArg(arg[i],XtNfont,xvf_font);                      i++;
   }
   XtCreateManagedWidget("error_text", asciiTextWidgetClass, back,arg,i);

   /* 
    * create the acknowledgment button 
    */
   i = 0;
   XtSetArg(arg[i],XtNfromHoriz,label);			i++;
   XtSetArg(arg[i],XtNwidth,button_width*xvf_font_width);	i++;
   if (xvf_font != NULL)
   {
        XtSetArg(arg[i],XtNfont,xvf_font);      	i++;
   }
   XtSetArg(arg[i],XtNlabel,xvf_strcpy(button1));	i++;
   ok = XtCreateManagedWidget("error_ok_wid",
	commandWidgetClass,back,arg,i);
   XtAddCallback(ok,XtNcallback,xvf_error_ok,toplevel);
   xvf_add_protocol_handler(toplevel, "WM_DELETE_WINDOW", xvf_error_ok,
				toplevel);

   /*
    *  place window and add handler delete window handler
    */
   xvf_place_widget(toplevel, ok);
   return(true);
}

/* callback for error form */

void xvf_error_ok(widget, clientData, callData)
Widget widget;
caddr_t clientData, callData;
{
	Widget toplevel;

	toplevel = (Widget ) clientData;

	xvf_remove_protocol_handler(toplevel, "WM_DELETE_WINDOW", xvf_error_ok,
				toplevel);
	xvf_delete_toplevel(toplevel);
	XtUnmapWidget(toplevel);
	XtDestroyWidget(toplevel);
	ERROR_DONE = true;
}
