 /*
  * Khoros: $Id: forms.c,v 1.2 1991/10/02 00:09:21 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: forms.c,v 1.2 1991/10/02 00:09:21 khoros Exp $";
#endif

 /*
  * $Log: forms.c,v $
 * Revision 1.2  1991/10/02  00:09:21  khoros
 * HellPatch2
 *
  */ 


/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 *
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "cantata.h"


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>	    file name:  forms.c                               <<<<
   >>>>                                                       <<<<
   >>>>   description:                                        <<<<
   >>>>                                                       <<<<
   >>>>      routines:  xvf_create_bitmap()                   <<<<
   >>>>                 xvf_create_command()                  <<<<
   >>>>                 xvf_create_label()                    <<<<
   >>>>                 xvf_create_back()                     <<<<
   >>>>                 xvf_find_sel_guide()                  <<<<
   >>>>                                                       <<<<
   >>>> modifications:					      <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */



/************************************************************
*
* Routine Name:  xvf_create_bitmap
*
*      Purpose:  This routine is used to create a bitmap command
*		 widget.  The widget allows the user to specify
*		 the parent, the name, the bitmap, and four other
*		 pieces of information helpful in placing the
*		 widget inside it's parent.
*
*        Input:  parent - the parent to the widget
*		 name   - the name of the widget
*		 pixmap - the bitmap to be used
*		 fromHoriz  - the widget that is on our left.
*		 fromVert   - the widget that is above us
*		 horizDist  - the horizontal distance from the
*			      "horizDist" widget
*		 vertDist   - the vertical distance from the
*			      "fromVert" widget
*
*
*   Written By: Mark Young
*
*************************************************************/


Widget xvf_create_bitmap(parent, name, pixmap, fromHoriz, fromVert, horizDist,
			 vertDist, options, num_opts)

Widget	parent, fromHoriz, fromVert;
char	*name;
Pixmap  pixmap;
int	horizDist, vertDist, num_opts;
Arg	*options;
{
	int	i;
	Widget  button;
	Arg	arg[25], *list;
   
	i = 0;
	XtSetArg(arg[i], XtNbitmap, pixmap);				i++;
	XtSetArg(arg[i], XtNhorizDistance, horizDist);			i++;
	XtSetArg(arg[i], XtNvertDistance,  vertDist);			i++;
	XtSetArg(arg[i], XtNfromHoriz, fromHoriz);			i++;
	XtSetArg(arg[i], XtNfromVert,  fromVert);			i++;
	XtSetArg(arg[i], XtNinternalHeight, 1);				i++;
	XtSetArg(arg[i], XtNinternalWidth, 1);				i++;

	if (options != NULL && num_opts > 0)
	{
	   list = XtMergeArgLists(arg, i, options, num_opts);
	   i = i + num_opts;
	}
	else
	   list = arg;

	button = XtCreateManagedWidget(name, commandWidgetClass, parent,list,i);

	if (options != NULL && num_opts > 0)
	   XtFree(list);

	return(button);
}



/************************************************************
*
* Routine Name:  xvf_create_command
*
*      Purpose:  This routine is used to create a label command
*		 widget.  The widget allows the user to specify
*		 the parent, the name, the label, and four other
*		 pieces of information helpful in placing the
*		 widget inside it's parent.
*
*        Input:  parent - the parent to the widget
*		 name   - the name of the widget
*		 label -  the label to be used
*		 fromHoriz  - the widget that is on our left.
*		 fromVert   - the widget that is above us
*		 horizDist  - the horizontal distance from the
*			      "horizDist" widget
*		 vertDist   - the vertical distance from the
*			      "fromVert" widget
*
*
*   Written By: Mark Young
*
*************************************************************/


Widget xvf_create_command(parent, name, label, fromHoriz, fromVert, horizDist,
			 vertDist, width, font, options, num_opts)

Widget	parent, fromHoriz, fromVert;
char	*name, *label;
XFontStruct *font;
int	horizDist, vertDist, width, num_opts;
Arg	*options;
{
	int	i;
	Widget  button;
	Arg	arg[25], *list;
   
	i = 0;
	XtSetArg(arg[i], XtNhorizDistance, horizDist);			i++;
	XtSetArg(arg[i], XtNvertDistance,  vertDist);			i++;
	XtSetArg(arg[i], XtNfromHoriz, fromHoriz);			i++;
	XtSetArg(arg[i], XtNfromVert,  fromVert);			i++;
	XtSetArg(arg[i], XtNinternalHeight, 1);				i++;
	XtSetArg(arg[i], XtNinternalWidth, 1);				i++;

	if (font != NULL)
	{
	   XtSetArg(arg[i], XtNfont, font);				i++;
	}
	if (label != NULL)
	{
	   XtSetArg(arg[i], XtNlabel, label);				i++;
	}
	if (width != 0)
	{
	   XtSetArg(arg[i], XtNwidth, width);				i++;
	}

	if (options != NULL && num_opts > 0)
	{
	   list = XtMergeArgLists(arg, i, options, num_opts);
	   i = i + num_opts;
	}
	else
	   list = arg;

	button = XtCreateManagedWidget(name, commandWidgetClass, parent,list,i);

	if (options != NULL && num_opts > 0)
	   XtFree(list);

	return(button);
}



/************************************************************
*
* Routine Name:  xvf_create_label
*
*      Purpose:  This routine is used to create a label widget.
*		 The routine allows the user to specify the parent,
*		 the label, and four other pieces of information
*		 helpful in placing the widget inside it's parent.
*
*        Input:  parent - the parent to the widget
*		 label   - the label and name of the widget
*		 fromHoriz  - the widget that is on our left.
*		 fromVert   - the widget that is above us
*		 horizDist  - the horizontal distance from the
*			      "horizDist" widget
*		 vertDist   - the vertical distance from the
*			      "fromVert" widget
*
*
*   Written By: Mark Young
*
*************************************************************/


Widget xvf_create_label(parent, title, fromHoriz, fromVert, horizDist, vertDist,
			width, font, options, num_opts)

Widget	    parent, fromHoriz, fromVert;
char	    *title;
XFontStruct *font;
int	    horizDist, vertDist, width, num_opts;
Arg	    *options;
{
	int	i;
	Widget  label;
	Arg	arg[25], *list;
   
	i = 0;
	XtSetArg(arg[i], XtNborderWidth, 0);				i++;
	XtSetArg(arg[i], XtNhorizDistance, horizDist);			i++;
	XtSetArg(arg[i], XtNvertDistance,  vertDist);			i++;
	XtSetArg(arg[i], XtNfromHoriz, fromHoriz);			i++;
	XtSetArg(arg[i], XtNfromVert,  fromVert);			i++;
	if (title != NULL)
	{
	   XtSetArg(arg[i], XtNlabel, title);			        i++;
	}
	if (font != NULL)
	{
	   XtSetArg(arg[i], XtNfont, font);				i++;
	}
	if (width != 0)
	{
	   XtSetArg(arg[i], XtNwidth, width);			        i++;
	}


	if (options != NULL && num_opts > 0)
	{
	   list = XtMergeArgLists(arg, i, options, num_opts);
	   i = i + num_opts;
	}
	else
	   list = arg;

	label = XtCreateManagedWidget(title, labelWidgetClass, parent, list, i);

	if (options != NULL && num_opts > 0)
	   XtFree(list);

	return(label);
}



/************************************************************
*
* Routine Name:  xvf_create_back
*
*      Purpose:  This routine is used to create a back widget.
*		 The routine allows the user to specify the parent,
*		 the name, and four other pieces of information
*		 helpful in placing the widget inside it's parent.
*
*        Input:  parent - the parent to the widget
*		 name   - the name of the widget
*		 fromHoriz  - the widget that is on our left.
*		 fromVert   - the widget that is above us
*		 horizDist  - the horizontal distance from the
*			      "horizDist" widget
*		 vertDist   - the vertical distance from the
*			      "fromVert" widget
*
*
*   Written By: Mark Young
*
*************************************************************/


Widget xvf_create_back(parent, name, fromHoriz, fromVert, horizDist, vertDist,
		       options, num_opts)

Widget	parent, fromHoriz, fromVert;
char	*name;
int	horizDist, vertDist, num_opts;
Arg	*options;
{
	int	i;
	Widget  back;
	Arg	arg[25], *list;
   
	i = 0;
	XtSetArg(arg[i], XtNwidth, 50);					i++;
	XtSetArg(arg[i], XtNheight, 50);				i++;
	XtSetArg(arg[i], XtNhorizDistance, horizDist);			i++;
	XtSetArg(arg[i], XtNvertDistance,  vertDist);			i++;
	XtSetArg(arg[i], XtNfromHoriz, fromHoriz);			i++;
	XtSetArg(arg[i], XtNfromVert,  fromVert);			i++;
	XtSetArg(arg[i], XtNresizable, True);				i++;
	XtSetArg(arg[i], XtNmappedWhenManaged, False);			i++;
	XtSetArg(arg[i], XtNdefaultDistance, 2);			i++;

	if (options != NULL && num_opts > 0)
	{
	   list = XtMergeArgLists(arg, i, options, num_opts);
	   i = i + num_opts;
	}
	else
	   list = arg;

	back = XtCreateManagedWidget(name, formWidgetClass, parent, list, i);

	if (options != NULL && num_opts > 0)
	   XtFree(list);

	return(back);
}

/************************************************************
*
*  Routine Name: xvf_find_sel_guide
*
*      Purpose:  searches for a particular guide in the
*		 form tree based on the provided index as the key.
*		 returns the guide pane on which the selection is found.
*
*        Input:  formptr - pointer to the subform tree
*		 index   - desired key 
*
*       Output:  pointer to the correct subform, or
*		 NULL if a selection with the desired index could
*		 not be found
*
*    Called By:  run_form
*
*   Written By:  Danielle Argiro
*
*************************************************************/


xvf_guide_button *xvf_find_sel_guide(formptr, index)

xvf_form *formptr;
int	  index;
{
	xvf_sub_form *subform;
	xvf_selection *selection;
	xvf_guide_button *guide;

	subform = formptr->subform;
	while (subform != NULL)
	{
	     guide = subform->guide_button;
	     while (guide != NULL) 
	     {
		if (guide->index == index)
		   return(guide);
	        else if (guide->pane != NULL)
	        {
		     selection = guide->pane->sel_list;
	   
	             while (selection != NULL) 
	             {
			 if (selection->index == index)
			    return(guide);

		         selection = selection->next;
	             }
	        }
	        guide = guide->next_button;
	     }
	     subform = subform->next_subform;
	}
	return(NULL);
}
