 /*
  * Khoros: $Id: liconimage.c,v 1.4 1992/03/20 22:50:52 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: liconimage.c,v 1.4 1992/03/20 22:50:52 dkhoros Exp $";
#endif

 /*
  * $Log: liconimage.c,v $
 * Revision 1.4  1992/03/20  22:50:52  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1992, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1992 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: liconimage.c
 >>>>
 >>>>      Program Name: iconimage
 >>>>
 >>>> Date Last Updated: Fri Feb 28 15:32:57 1992 
 >>>>
 >>>>          Routines: liconimage - the library call for iconimage
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "xvinclude.h"


/* -library_includes */
#include "iconimage.h"

int      desired_width, desired_height;
Display  *display;
/* -library_includes_end */


/****************************************************************
*
* Routine Name: liconimage - library call for iconimage
*
* Purpose:
*
* Input:
* Output:
*
* Written By: Mark Young and Stephanie Hallet
****************************************************************/


/* -library_def */
int
liconimage(img_infile, ov_infile, shape_infile, clip_infile,
           xoffset, yoffset, width, height, update, display_name, use_cmap)
char    *img_infile, *ov_infile, *shape_infile, *clip_infile;
int     xoffset, yoffset, width, height;
float   update;
char    *display_name;
int     use_cmap;

/* -library_def_end */

/* -library_code */
{
        int      update_file();
        void     iconimage_exit();

        unsigned long mask;
        int       scale;
        float     xstep, ystep;
        DisplayStructure *xvdisplay;
        char     *name, temp[MAXBUF];
        struct xvimage *image, *overlay, *shape, *clip, *readimage();


        /*
         *  Initialize image, widgets,  and file update
         *  mechanism.
         */
        if (display_name != NULL)
        {
           (void) sprintf(temp, "DISPLAY=%s", display_name);
           vputenv(xvf_strcpy(temp));
        }

        display = xvf_initialize(ac, av, program);
        if (display == NULL)
        {
             fprintf(stderr, "Could not open connection to server");
             return(False);
        }

        /*
         *  initializes structures for use of xvdisplay library
         */
        xvd_initialize(display);

        /*
         * create the image widget
         */
        image = readimage(img_infile);
        if (image == NULL) return(false);

        desired_width  = width;
        desired_height = height;

        /*
         *  compute size to shrink image to
         */
        width  = MIN(desired_width, image->row_size);
        height = MIN(desired_height, image->col_size);
        if (width == 0) width = 1;
        if (height == 0) height = 1;
        xstep = image->row_size/width;
        ystep = image->col_size/height;
        scale = MAX(xstep, ystep) + 0.5;
        if (scale == 0) scale = 1;


        /*
         * create the image icon
         */
        if (shape_infile != NULL) shape = readimage(shape_infile);
        else shape = NULL;

        if (clip_infile != NULL) clip = readimage(clip_infile);
        else clip = NULL;

        if (ov_infile != NULL) overlay = readimage(ov_infile);
        else overlay = NULL;

        /*
         *  shrink image into icon size
         */
        if (scale > 1)
        {
           if (!lvshrink(image, scale)) return(false);

           if (overlay != NULL)
              if (!lvshrink(overlay, scale)) overlay = NULL;
           if (clip != NULL)
              if (!lvshrink(clip, scale)) clip = NULL;
           if (shape != NULL)
              if (!lvshrink(shape, scale)) shape = NULL;
        }

        /*
         *  After reading in the display image, if use_cmap is False then
         *  we should delete the maps associated with that image.
         */
        if (use_cmap == False)
        {
           if (image->maps != NULL) free(image->maps);
           image->maps              = NULL;
           image->map_storage_type  = VFF_MAPTYP_NONE;
           image->map_scheme        = VFF_MS_NONE;
           image->map_enable        = VFF_MAP_OPTIONAL;
           image->color_space_model = VFF_CM_NONE;
           image->map_row_size    =
           image->map_col_size    =
           image->map_subrow_size = 0;
        }

        /*
         * create the image widget
         */
        name = vbasename(img_infile);
        xvdisplay = xvd_create_xvdisplay(display, image, shape, clip, overlay,
                                True, True, name, xoffset, yoffset, False);


        /*
         *  Add detect code to update when the image updates.
         */
        if (update != 0.0)
           (void) xvf_detect_file(img_infile, update, update_file, xvdisplay);

        /*
         *  add event handler that will call iconimage_exit when the
         *  user clicks on the image
         */
        mask = ButtonPressMask | ButtonReleaseMask | KeyPressMask;
        XtAddEventHandler(xvdisplay->raster, mask, False, iconimage_exit, NULL);
        
        /*
         *  display the icon image until the user clicks on it
         */
        ICONIMAGE_DONE = False;
        while (!ICONIMAGE_DONE)
        {
           xvf_process_event();      /* this does XtNextEvent/DispatchEvent*/
        }

        /*
         *  The user exits by performing a button press on the image widget,
         *  which sets XVICON_DONE to True.
         */
        xvd_delete_image(xvdisplay);
        XSync(display, 0); XCloseDisplay(display);
        return(TRUE);
}



void  iconimage_exit(widget, clientData, event, dispatch)

Widget  widget;                /* unused */
caddr_t clientData;            /* unused */
XEvent  *event;
Boolean *dispatch;
{
        char   character;


        if (event->type == ButtonRelease)
        {
           ICONIMAGE_DONE = True;
        }
        else if (event->type == KeyPress)
        {
           if (XLookupString(&(event->xkey), &character, 1, NULL, NULL)  == 0)
              return;

           switch (character)
           {
                case   3:
                case 'q':
                case 'Q':
                        ICONIMAGE_DONE = True;
                        break;
           }
        }

}

int update_file(id, filename, data)

int  id;
char *filename;
char *data;
{
        struct xvimage *image, *readimage();
        DisplayStructure *xvdisplay = (DisplayStructure *) data;

        float     xstep, ystep;
        int       scale, width, height;


        if (!(image = readimage(filename)))
           return(False);

        /*
         *  compute size to shrink image to
         */
        width  = MIN(desired_width, image->row_size);
        height = MIN(desired_height, image->col_size);
        xstep = image->row_size/width;
        ystep = image->col_size/height;
        scale = MAX(xstep, ystep) + 0.5;

        /*
         *  shrink image into icon size
         */
        if (scale > 1)
        {
           if (!lvshrink(image, scale))
              return(False);
        }
        xvd_update_image(xvdisplay, image);
        return(True);
}

int flush()
{
        XFlush(display);
        XSync(display, 0);
        return(1);
}
/* -library_code_end */
