 /*
  * Khoros: $Id: composepath.c,v 1.2 1991/12/18 09:19:03 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: composepath.c,v 1.2 1991/12/18 09:19:03 dkhoros Exp $";
#endif

 /*
  * $Log: composepath.c,v $
 * Revision 1.2  1991/12/18  09:19:03  dkhoros
 * HellPatch3
 *
  */
/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 *
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 *
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */
#include "kraftsman.h"

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>     file name: composepath.c                          <<<<
   >>>>                                                       <<<<
   >>>>   description: File Utility                           <<<<
   >>>>                                                       <<<<
   >>>>      routines: int vmkdir()                           <<<<
   >>>>                                                       <<<<
   >>>> modifications:                                        <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

/***********************************************************************
*
*  Routine Name: vcomposepath()
*
*          Date: 12/4/91
*
*       Purpose: Takes two parts of a path, cleans them up, and
*		 concatenates them together
*
*         Input: filename -- End portion of the pathname 
*		 dir -- Beginning portion of the pathname
*		 return_file -- string to return composed path
*
*		 NOTE: the path order may seem backward, but
*		 it was set this way to remain consistant
*		 with vfullpath, and vexpandpath.
*
*        Output: returns a pointer to the composed path on success
*			NULL on fail
*		 NOTE: if return_file is null the composed path
*		 will be malloc'ed, otherwise, the return_file
*		 field will contain the path
*
*    Written By: Steven Jorgensen
*
* Modifications:
*
***********************************************************************/
char *vcomposepath(filename,dir,return_file)
  char *filename, *dir, *return_file;
  {
    char npath1[LENGTH], npath2[LENGTH], npath3[LENGTH];
    char *npath1ptr = NULL, *npath2ptr = NULL;

    if (dir != NULL)
      npath1ptr = vcleanup_string(dir,npath1);
    if (filename != NULL)
      npath2ptr = vcleanup_string(filename,npath2);
    if (npath1ptr == NULL && npath2ptr == NULL)
      return(NULL);
    else if (npath1ptr == NULL)
      strcpy(npath3,npath2);
    else if (npath2 == NULL)
      strcpy(npath3,npath1);
    else
      {
	strcpy(npath3, npath1);
	if (npath1[VStrlen(npath1)-1] != '/' && npath2[0] != '/')
	  strcat(npath3, "/");
	strcat(npath3,npath2);
      }
    if (return_file == NULL)
      return(VStrcpy(npath3));
    strcpy(return_file,npath3);
    return(return_file);
  }
