 /*
  * Khoros: $Id: position.c,v 1.1 1991/05/10 15:59:17 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: position.c,v 1.1 1991/05/10 15:59:17 khoros Exp $";
#endif

 /*
  * $Log: position.c,v $
 * Revision 1.1  1991/05/10  15:59:17  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 * 
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *----------------------------------------------------------------------
 */
#include "unmcopyright.h"        /* Copyright 1990 by UNM */
#include "warpimage.h"

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>		Event Handlers for Position Widget            <<<<
   >>>>                                                       <<<<
   >>>>			xvw_update_zoom_position()	      <<<<
   >>>>			xvw_get_zoom_position()	    	      <<<<
   >>>>                                                       <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<  */


/************************************************************
*
*  MODULE NAME: xvw_update_zoom_position
*
*      PURPOSE: event handler which updates the information label 
*		on the position widget according to the position 
*		of the cursor in the zoom widget
*
*	 INPUT: widget - the widget that had the event
*		clientdata - used for the xvdisplay struct
*		event - the event that evoked this event handler
*
*       OUTPUT: none
*
*   WRITTEN BY: Mark Young
*
*************************************************************/

void xvw_update_zoom_position(widget, clientData, event, dispatch)

Widget  widget;
caddr_t clientData;
XEvent  *event;
Boolean *dispatch;
{
	double	    value;
        char	    buf[25];
        Arg	    args[2];
	int	    i, x, y, allocated;

	DisplayStructure *xvdisplay;
	ZoomStructure *zoom;

	if (src_zoom->raster == widget)
	{
	    zoom = src_zoom;
	    xvdisplay = src_image;
	}
	else
	{
	    zoom = dest_zoom;
	    xvdisplay = dest_image;
	}

	xvw_get_zoom_position(widget, zoom, &x, &y);
	if (xvd_query_value(xvdisplay, x, y, &value, NULL, &allocated))
	{
	   if (allocated)
	      sprintf(buf,"%3d x %3d  = %0.3g", x, y, value);
	   else
	      sprintf(buf,"%3d x %3d  = %0.3g (*)", x, y, value);
	}
	else
	   sprintf(buf,"%3d x %3d", x, y);

	i = 0;
	XtSetArg(args[i], XtNlabel, buf);	  i++;
        XtSetValues(xvdisplay->position, args, i);
	XFlush(XtDisplay(widget));
}

/************************************************************
*
*  MODULE NAME: xvw_get_zoom_position
*
*      PURPOSE: Computes the x and y position of the pixel
*		in the image from the zoom cursors location
*		in the zoom box.
*
*	 INPUT: widget - the widget that had the event
*		zoom - a pointer to the zoom structure
*		x - a pointer to the x location computed
*		y - a pointer to the y location computed
*
*       OUTPUT: none
*
*   WRITTEN BY: Tom Sauer
*
*************************************************************/

xvw_get_zoom_position(widget, zoom, x, y)

Widget  widget;
ZoomStructure *zoom;
int *x, *y;
{
	int  width, height;

	if (xvd_query_position(widget, x, y, True))
	   return;

		/* 
		 * Figure out the x and y location of the cursor from
		 * that coorespond to the location in the actual image.
		 */

	if (zoom->mode == RubberBand)
	{
	   width  = (int) ((float) zoom->xoffset * zoom->zoomfactor);
           height = (int) ((float) zoom->yoffset * zoom->zoomfactor);

		/* calculate for x */
	   if ((*x < zoom->x_zoom_loc) || ( *x > (width + zoom->x_zoom_loc))) 
	      *x = -1;
	   else
	   {
	      *x -= zoom->x_zoom_loc;
	      *x = ((int) ((float) *x / zoom->zoomfactor)) + zoom->min_x;
	   }

		/* calculate for y */
	   if ((*y < zoom->y_zoom_loc) || ( *y > (height + zoom->y_zoom_loc))) 
	      *y = -1;
	   else
	   {
	      *y -= zoom->y_zoom_loc;
	      *y = ((int) ((float) *y / zoom->zoomfactor)) + zoom->min_y;
	   }
	}
	else /* zoom mode is Point and Click */
	{
	    width  = (int) ((float) ZoomDisplayWidth / zoom->zoomfactor);
	    height = (int) ((float) ZoomDisplayHeight / zoom->zoomfactor);

		/* calculate for x */
	    if (*x < zoom->x_zoom_loc || *x > zoom->xoffset + zoom->x_zoom_loc)
	       *x = -1;
	    else
	    {
	       *x -= zoom->x_zoom_loc;
	       if (zoom->min_x < width /2)
	          *x  = ((int) ((float) *x / zoom->zoomfactor));
	       else
	          *x  = ((int) ((float) *x / zoom->zoomfactor)) +
				(zoom->min_x - width /2);
	    }

		/* calculate for y */
	    if (*y < zoom->y_zoom_loc || *y > zoom->yoffset + zoom->y_zoom_loc)
	       *y = -1;
	    else
	    {
	       *y -= zoom->y_zoom_loc;
	       if (zoom->min_y < (height/2))
	          *y  = (int) ((float) *y / zoom->zoomfactor);
	       else
	          *y  = ((int) ((float) *y / zoom->zoomfactor)) +
				(zoom->min_y - height /2);
	    }

	}
	  /* 
	   * if either the x or the y is not zooming in the image
	   * then set both to -1 
           */

	if (*x == -1 || *y == -1)
	{
	   *x = -1;
	   *y = -1;
	}
}
