/*
 *---------------------------------------------------------------------
 *            Copyright 1990 University of New Mexico
 * 
 * Permission to copy and modify this software and its documen- 
 * tation only for internal use in your organization is hereby 
 * granted, provided that this notice is retained thereon and 
 * on all copies.  UNM makes no representations as too the sui- 
 * tability and operability of this software for any purpose. 
 * It is provided 'as is' without express or implied warranty. 
 *  
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, 
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT- 
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL, 
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT- 
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER 
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS 
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER- 
 * FORMANCE OF THIS SOFTWARE. 
 *  
 * No other rights, including for example, the right to redis- 
 * tribute this software and its documentation or the right to 
 * prepare derivative works, are granted unless specifically 
 * provided in a separate license agreement. 
 * 
 *---------------------------------------------------------------------
 */
#include "unmcopyright.h"
#include "xvforms.h"
#include <strings.h>
#include "form_info.h"


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name:  form_info.c
 >>>>
 >>>>      Program Desc:  code to extract values
 >>>>                     from the graphical user interface 
 >>>>
 >>>>            Author:  automatically generated by conductor
 >>>>
 >>>> Date Last Updated:  Mon Feb 18 16:13:07 1991
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


/********************************************************
*
*  Routine Name: xvf_get_Master
*
*       Purpose: Fills in the user-specified
*                'Master'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                forminfo - pointer to the user-specified
*                'Master'
*
*       Output:  current values stored in  Master
*
*    Called By:  the application program when appropriate
*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_Master(formptr, forminfo)

xvf_form *formptr;
Master *forminfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;

	/***** getting 'Master' Form Information structure *****/


	index = 4;

	xvf_parse_master_action_line(database[index], &line_info);
	forminfo->master_action = line_info.selected;

	index = 5;

	xvf_parse_workspace_line(database[index], &line_info);
	forminfo->workspace = line_info.workspace;

	index = 8;

	xvf_parse_quit_line(database[index], &line_info);
	forminfo->quit = line_info.selected;

	index = 10;

	xvf_parse_startsubform_line(database[index], &line_info);
	forminfo->Subform1_selected = line_info.selected;
	_xvf_get_Subform1(formptr, forminfo->Subform1);

	index = 28;

	xvf_parse_startsubform_line(database[index], &line_info);
	forminfo->Subform2_selected = line_info.selected;
	_xvf_get_Subform2(formptr, forminfo->Subform2);

}

/********************************************************
*
*  Routine Name: xvf_get_Subform1
*
*       Purpose: Fills in the user-specified
*                'Master_Subform1'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                subforminfo - pointer to the user-specified
*                'Master_Subform1'
*
*       Output:  current values stored in  'Master_Subform1'
*
*    Called By:  xvf_get_*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_Subform1(formptr, subforminfo)

xvf_form *formptr;
Master_Subform1 *subforminfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 11;


	/*** extracting 'Master->Subform1'
 	   Subform Information structure ***/


	index = 14;

	xvf_parse_subform_action_line(database[index], &line_info);
	subforminfo->operation = line_info.selected;

	index = 15;

	xvf_parse_quit_line(database[index], &line_info);
	subforminfo->quit = line_info.selected;

	index = 17;
	xvf_parse_startpane_line(database[index], &line_info);
	subforminfo->input_selected = line_info.selected;
	_xvf_get_input(formptr, subforminfo->input);

	index = 23;
	xvf_parse_startpane_line(database[index], &line_info);
	subforminfo->output_selected = line_info.selected;
	_xvf_get_output(formptr, subforminfo->output);

}



/********************************************************
*
*  Routine Name: xvf_get_Subform2
*
*       Purpose: Fills in the user-specified
*                'Master_Subform2'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                subforminfo - pointer to the user-specified
*                'Master_Subform2'
*
*       Output:  current values stored in  'Master_Subform2'
*
*    Called By:  xvf_get_*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_Subform2(formptr, subforminfo)

xvf_form *formptr;
Master_Subform2 *subforminfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 29;


	/*** extracting 'Master->Subform2'
 	   Subform Information structure ***/


	index = 29;
	xvf_parse_startpane_line(database[index], &line_info);
	subforminfo->transforms_selected = line_info.selected;
	_xvf_get_transforms(formptr, subforminfo->transforms);

}



/********************************************************
*
*  Routine Name: xvf_get_input
*
*       Purpose: Fills in the user-specified
*                'Subform1_input'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                paneinfo - pointer to the user-specified
*                'Subform1_input'
*
*       Output:  current values stored in  'Subform1_input'
*
*    Called By:  xvf_get_Subform1
*

*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_input(formptr, paneinfo)

xvf_form *formptr;
Subform1_input *paneinfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 18;


	/* extracting 'Master->Subform1->input'
 	   Pane Information structure */

	xvf_parse_input_line(database[index], &line_info);
	if (line_info.filename != NULL) {
	   paneinfo->infile = 
		xvf_strcpy(line_info.filename);
	}
	else  paneinfo->infile = NULL;

	index++;

	xvf_parse_logic_line(database[index], &line_info);
	paneinfo->add_file = line_info.logical_val;
	index++;

	xvf_parse_logic_line(database[index], &line_info);
	paneinfo->delete_file = line_info.logical_val;
	index++;

	xvf_parse_pane_action_line(database[index], &line_info);
	paneinfo->get_input = line_info.selected;
	index++;



}


/********************************************************
*
*  Routine Name: xvf_get_output
*
*       Purpose: Fills in the user-specified
*                'Subform1_output'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                paneinfo - pointer to the user-specified
*                'Subform1_output'
*
*       Output:  current values stored in  'Subform1_output'
*
*    Called By:  xvf_get_Subform1
*

*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_output(formptr, paneinfo)

xvf_form *formptr;
Subform1_output *paneinfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 24;


	/* extracting 'Master->Subform1->output'
 	   Pane Information structure */

	xvf_parse_output_line(database[index], &line_info);
	if (line_info.filename != NULL) {

	   paneinfo->outfile = 
		xvf_strcpy(line_info.filename);
	}
	else  paneinfo->outfile = NULL;

	paneinfo->outfile_selected = line_info.selected;
	index++;

	xvf_parse_pane_action_line(database[index], &line_info);
	paneinfo->save_output = line_info.selected;
	index++;



}


/********************************************************
*
*  Routine Name: xvf_get_transforms
*
*       Purpose: Fills in the user-specified
*                'Subform2_transforms'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                paneinfo - pointer to the user-specified
*                'Subform2_transforms'
*
*       Output:  current values stored in  'Subform2_transforms'
*
*    Called By:  xvf_get_Subform2
*

*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_transforms(formptr, paneinfo)

xvf_form *formptr;
Subform2_transforms *paneinfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 30;


	/* extracting 'Master->Subform2->transforms'
 	   Pane Information structure */

	xvf_parse_toggle_line(database[index], &line_info);
	paneinfo->trans_type_val = line_info.toggle_val;
	index++;

	index = 35;
	xvf_parse_float_line(database[index], &line_info);
	paneinfo->x_val = line_info.float_val;
	index++;

	xvf_parse_float_line(database[index], &line_info);
	paneinfo->y_val = line_info.float_val;
	index++;

	xvf_parse_int_line(database[index], &line_info);
	paneinfo->int2 = line_info.int_val;
	index++;

	xvf_parse_int_line(database[index], &line_info);
	paneinfo->int1 = line_info.int_val;
	index++;

	index = 40;
	xvf_parse_string_line(database[index], &line_info);
	if (line_info.string_val != NULL) {
	   paneinfo->string1 = 
		xvf_strcpy(line_info.string_val);
	}
	else  paneinfo->string1 = NULL;

	paneinfo->string1_selected = line_info.opt_sel;
	index++;

	xvf_parse_string_line(database[index], &line_info);
	if (line_info.string_val != NULL) {
	   paneinfo->string2 = 
		xvf_strcpy(line_info.string_val);
	}
	else  paneinfo->string2 = NULL;

	paneinfo->string2_selected = line_info.opt_sel;
	index++;

	xvf_parse_string_line(database[index], &line_info);
	if (line_info.string_val != NULL) {
	   paneinfo->string3 = 
		xvf_strcpy(line_info.string_val);
	}
	else  paneinfo->string3 = NULL;

	paneinfo->string3_selected = line_info.opt_sel;
	index++;

	xvf_parse_int_line(database[index], &line_info);
	paneinfo->int4 = line_info.int_val;
	paneinfo->int4_selected = line_info.opt_sel;
	index++;

	index++;

	xvf_parse_pane_action_line(database[index], &line_info);
	paneinfo->do_something = line_info.selected;
	index++;

	xvf_parse_quit_line(database[index], &line_info);
	paneinfo->quit = line_info.selected;
	index++;



}


