 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 *   Copyright, 1991, The Regents of the University of California.
 *   This software was produced under a U.S. Government contract
 *   (W-7405-ENG-36) by the Los Alamos National Laboratory, which is
 *   operated by the University of California for the U.S. Department
 *   of Energy.  The U.S. Government is licensed to use, reproduce,
 *   and distribute this software.  Neither the Government nor the
 *   University makes any warranty, express or implied, or assumes
 *   any liability responsibility for the use of this software.
 */

#define free_cmatrix(m) (void)free((m)[0]);(void)free((m))
#define SM_copy_matrix(dim,A,B) { int zz1,zz2; for (zz1=0;zz1<(dim);zz1++) for ( zz2=zz1;zz2<(dim);zz2++) (B) [zz1][zz2] = (A) [zz1][zz2]; }

typedef struct {
     int size;           /* Size of stack */
     int cur_size;       /* Current number of items on stack */
     unsigned char *mem; /* Points to next available stack position */
} STACK_UC_TYPE;

typedef struct {
     int size;      /* Size of stack */
     int cur_size;  /* Current number of items on stack */
     float *mem;    /* Points to next available stack position */
} STACK_FLOAT_TYPE;

typedef struct {
     int size;      /* Size of stack */
     int cur_size;  /* Current number of items on stack */
     int *mem;      /* Points to next available stack position */
} STACK_INT_TYPE;

typedef struct {
     int rows;                     /* Number of rows */
     int cols;                     /* Number of columns */
     unsigned char **data;         /* The bitmap data */
} BITMAP_TYPE;

extern int get_bit ( /* bitmap, row, col */ ) ;
extern void dealloc_bitmap ( /* bitmap */ ) ;
extern BITMAP_TYPE *create_bitmap ( /* numr, numc, init */ ) ;
extern void set_bit ( /* bitmap, row, col, val */ ) ;
extern void bitmap_load ( /* fname, bitmap */ ) ;
extern void bitmap_save ( /* fname, bitmap */ ) ;

extern unsigned char **image_2d_uc ( ) ;
extern unsigned short **image_2d_us ( ) ;
extern float **image_2d_fl ( ) ;
extern int **image_2d_int ( ) ;

extern unsigned char **contig_matrix_uc ( ) ;
extern unsigned short **contig_matrix_us ( ) ;
extern int **contig_matrix_int ( ) ;
extern float **contig_matrix ( ) ;

extern int getstats ( ) ;
extern int putstats ( ) ;

extern float **SM_get_matrix ( ) ;
extern void SM_comb_stats ( ) ;
extern int SM_cfactor ( ) ;
extern void SM_csolve ( ) ;

extern float dot_product ( ) ;

extern void alloc_stack_uc ( /* s, max_size */ ) ;
extern void alloc_stack_fl ( /* s, max_size */ ) ;
extern void alloc_stack_int ( /* s, max_size */ ) ;

extern void dealloc_stack_uc ( /* s */ ) ;
extern void dealloc_stack_fl ( /* s */ ) ;
extern void dealloc_stack_int ( /* s */ ) ;

extern float pop_fl ( /* s */ ) ;
extern unsigned char pop_uc ( /* s */ ) ;
extern int pop_int ( /* s */ ) ;

extern void push_uc ( /* s, val */ ) ;
extern void push_fl ( /* s, val */ ) ;
extern void push_int ( /* s, val */ ) ;

#define mt_stack(s) ((s)->cur_size == 0)

extern void UT_find_min_pos_2 ();
extern int merge ();
extern int merge_alg_1 ();
extern int merge_alg_3 ();
