 /*
  * Khoros: $Id$
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>  		        Plot Drivers
 >>>>
 >>>>			run_scatter_plot()
 >>>>			run_scatter()
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#include "spectrum.h"


/********************************************************
*
*  Routine Name:  run_scatter_plot
*
*       Purpose:  drives the subform 'scatter_plot'
*
*         Input:  form - pointer to the form tree 
*		  scatter_plot_info  - information structure for subform 'scatter_plot'
*        Output:  action of the application program
*
*     Called By:  run_master()
*
*   Automatically Generated By:  conductor -i spectrum.form -l 3 -b
*
********************************************************/

run_scatter_plot(form, scatter_plot_info)

xvf_form *form;
master_scatter_plot *scatter_plot_info;
{

	_xvf_get_scatter_plot(form, scatter_plot_info);

	/*
	 * action came from the 'scatter' pane
	 */
	if (scatter_plot_info->scatter_selected)
	    run_scatter(form, scatter_plot_info->scatter);


}   /* end run_scatter_plot */





/********************************************************
*
*  Routine Name:  run_scatter
*
*       Purpose:  drives the pane 'scatter'
*
*         Input:  form - pointer to the form tree 
*		  scatter_info  - information structure for pane 'scatter'
*        Output:  action of the application program
*
*     Called By:  run_scatter_plot()
*
*   Automatically Generated By:  conductor -i spectrum.form -l 3 -b
*
********************************************************/



#define SetZoom 1
#define Reset   2

run_scatter(form, scatter_info)

xvf_form *form;
scatter_plot_scatter *scatter_info;
{
	static int zoom_status = SetZoom;
	float min, max;

	_xvf_get_scatter(form, scatter_info);

	/*
	 * user clicked on pane action button 'select'
	 */
	if (scatter_info->operation_selected)
	      spc_plot_operation = scatter_info->operation;

	/*
	 *  user entered new zoom factor
	 */
	else if (scatter_info->zoomfactor_selected)
	{
	      spc_potential_plot_zoomfactor = scatter_info->zoomfactor;
	      spc_draw_plot_zoombox = true;
	      if (zoom_status == Reset) return;
	      draw_plot();
	}

	/*
	 *  user clicked on "live" logical selection "proportional plotting"
	 */
	else if (scatter_info->prop_selected)
	{
	      spc_prop_plotting = scatter_info->prop;
	      if (spc_image == NULL) return;

	      if (spc_prop_plotting)
              {
                find_min_max_col_data(spc_x_col, spc_unique_values, &min, &max);
                min = MIN(min, spc_wcmin.y);
                max = MAX(max, spc_wcmax.y);
                spc_wcmin.x = min; spc_wcmax.x = max;

	        find_min_max_col_data(spc_y_col, spc_unique_values, &min, &max);
                min = MIN(spc_wcmin.x, min);
                max = MAX(spc_wcmax.x, max);
                spc_wcmin.y = min; spc_wcmax.y = max;
              }
	      else
	      {
		find_min_max_col_data(spc_x_col, spc_unique_values, &min, &max);
                spc_wcmin.x = min; spc_wcmax.x = max;

	 	find_min_max_col_data(spc_y_col, spc_unique_values, &min, &max);
                spc_wcmin.y = min; spc_wcmax.y = max;
	      }

	      draw_plot();
	}

  	/*
         * protect against any other action if an image 
	 * has not been input as of yet
	 */
	else if (spc_image == NULL)
	{
	     xvf_error_wait("Please input a VIFF image before attempting any other operation.", "Spectrum", NULL);
	     if (scatter_info->x_func_selected)
	        xvf_change_input(form, scatter_info->x_func_index,
			         xvf_stringval_chng, current_red_func, 30);
	     else if (scatter_info->y_func_selected)
                xvf_change_input(form, scatter_info->y_func_index,
                                 xvf_stringval_chng, current_green_func, 30);

	     return;
	}

	else if (scatter_info->set)
	{
	      if (zoom_status == SetZoom)
	      {
	      spc_potential_plot_zoomfactor = scatter_info->zoomfactor;
	      spc_actual_plot_zoomfactor = spc_potential_plot_zoomfactor;
	      spc_draw_plot_zoombox = false;
              draw_plot();
	      XtRemoveEventHandler(plot_workspace, ButtonPressMask,
                                   FALSE, update_plot_focus, NULL);
	      xvf_change_input(form, scatter_info->set_index,
			       xvf_title_chng, "Reset", 9);
	      zoom_status = Reset;
	      }
	      else
	      {
	      spc_actual_plot_zoomfactor = 1.0;
	      spc_draw_plot_zoombox = true;
	      draw_plot();
	      XtInsertEventHandler(plot_workspace, ButtonPressMask,
                                   FALSE, update_plot_focus, NULL, XtListHead);
	      xvf_change_input(form, scatter_info->set_index,
			       xvf_title_chng, "Set Zoom", 9);
	      zoom_status = SetZoom;
	      }
	}
	/*
	 * user clicked on pane action button 'select'
	 */
	else if (scatter_info->select)
	{
	      if (spc_legend_list == 0)
	      {
		  xvf_error_wait("No classes to choose from!", 
				 "Spectrum", NULL);
		  return;
	      }
	      update_current_class();
	      xvf_change_input(form, scatter_info->select_index + 1,
			       xvf_title_chng, current_entry->legend_ptr->text,
			       50);
	      spc_draw_plot_zoombox = false;
	      draw_plot();
	}
	    
	/*
	 * user clicked on pane action button 'x_column'
	 */
	else if (scatter_info->x_column)
	      change_plot_col(form, scatter_info->x_column_index + 1, 
			      scatter_info->x_func_index, SpcX);

	/*
	 * user clicked on pane action button 'y_column'
	 */
	else if (scatter_info->y_column)
	      change_plot_col(form, scatter_info->y_column_index + 1, 
			      scatter_info->y_func_index, SpcY);

	else if (scatter_info->x_func_selected)
	{
	      change_plot_function(scatter_info->x_func, SpcX);
	      spc_draw_plot_zoombox = false;
	      draw_plot();
	      xvf_change_input(form, scatter_info->x_column_index + 1,
			       xvf_title_chng, scatter_info->x_func, 30);
	}
	else if (scatter_info->y_func_selected)
	{
	      change_plot_function(scatter_info->y_func, SpcY);
	      spc_draw_plot_zoombox = false;
	      draw_plot();
	      xvf_change_input(form, scatter_info->y_column_index + 1,
			       xvf_title_chng, scatter_info->y_func, 30);
	}

}

