/* wmesa.h */

/*
 * Mesa 3-D graphics library
 * Version:  1.2 beta
 * Copyright (C) 1995  Brian Paul  (brianp@ssec.wisc.edu)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Windows driver by: Mark E. Peterson (markp@ic.mankato.mn.us)
 *
 */

#ifndef WMESA_H
#define WMESA_H


#ifdef __cplusplus
extern "C" {
#endif


#include <windows.h>
#include "gl\gl.h"


/*
 * This is the WMesa context 'handle':
 */
typedef struct wmesa_context *WMesaContext;



/*
 * Create a new WMesaContext for rendering into a window.  You must
 * have already created the window of correct visual type and with an
 * appropriate colormap.
 *
 * Input:
 *         hWnd - Window handle
 *         Pal  - Palette to use
 *         rgb_flag - GL_TRUE = RGB mode,
 *                    GL_FALSE = color index mode
 *         db_flag - GL_TRUE = double-buffered,
 *                   GL_FALSE = single buffered
 *
 * Note: Indexed mode requires double buffering under Windows.
 *
 * Return:  a WMesa_context or NULL if error.
 */
// changed 130795 Gerbert Orasche
extern WMesaContext WMesaCreateContext(HWND hWnd,HPALETTE Pal,
                                       GLboolean rgb_flag,GLboolean db_flag);


/*
 * Destroy a rendering context as returned by WMesaCreateContext()
 */
extern void WMesaDestroyContext( WMesaContext ctx );


/*
 * Make the specified context the current one.
 */
// changed 130795 Gerbert Orasche
extern void WMesaMakeCurrent( WMesaContext ctx, HDC draw_dc);


/*
 * Return a handle to the current context.
 */
extern WMesaContext WMesaGetCurrentContext( void );


/*
 * Swap the front and back buffers for the current context.  No action
 * taken if the context is not double buffered.
 */
extern void WMesaSwapBuffers(HDC draw_dc);



// In indexed color mode we need to know when the palette changes.
extern void WMesaPaletteChange(HPALETTE Pal);


#ifdef __cplusplus
}
#endif


#endif

