/* 
 * Mach Operating System
 * Copyright (c) 1992 Carnegie Mellon University
 * All Rights Reserved.
 * 
 * Permission to use, copy, modify and distribute this software and its
 * documentation is hereby granted, provided that both the copyright
 * notice and this permission notice appear in all copies of the
 * software, derivative works or modified versions, and any portions
 * thereof, and that both notices appear in supporting documentation.
 * 
 * CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
 * CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
 * ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 * 
 * Carnegie Mellon requests users of this software to return to
 * 
 *  Software Distribution Coordinator  or  Software.Distribution@CS.CMU.EDU
 *  School of Computer Science
 *  Carnegie Mellon University
 *  Pittsburgh PA 15213-3890
 * 
 * any improvements or extensions that they make and grant Carnegie Mellon 
 * the rights to redistribute these changes.
 */
/*
 * HISTORY
 * $Log:	conf.c,v $
 * Revision 2.5  92/02/23  22:45:29  elf
 * 	Added getstat routines for xy and sd drivers.
 * 	[92/02/22  19:54:08  af]
 * 
 * Revision 2.4  91/08/28  11:17:44  jsb
 * 	Added entries for new dev_info field.
 * 	[91/08/27  17:56:37  jsb]
 * 
 * Revision 2.3  90/11/05  14:32:36  rpd
 * 	Added ie and xy from NCSC.
 * 	[90/10/26            rwd]
 * 
 * Revision 2.2  89/08/05  16:07:32  rwd
 * 	Added time device
 * 	[89/08/04            rwd]
 * 
 */
#include <device/conf.h>

extern int block_io_mmap();

extern int cnopen(),cnclose(),cnread(),cnwrite(),cngetstat(),cnsetstat(),
	cnportdeath();
#define	cnname		"cl"

extern int timeopen(),timeclose(),timemmap();
#define timename	"time"

#include <xy.h>
#if	NXY > 0
extern	int	xyopen(), xyread(), xywrite(), xygetstat();
#define	xyname	"xy"
#endif

#include <sd.h>
#if NSD > 0
extern int sdopen(),sdread(),sdwrite(),sdgetstat();
#define sdname "sd"
#endif

#include <zs.h>
#if NZS > 0
extern int zsopen(),zsclose(),zsread(),zswrite(),zsgetstat(),zssetstat(),
	zsportdeath();
#define zsname	"zs"
#endif

#include <ie.h>
#if NIE > 0
extern int ieopen(),ieoutput(),iegetstat(),iesetstat(),iereset(),
	iesetinput();
#define iename "ie"
#endif

#include <le.h>
#if NLE > 0
extern int leopen(),leoutput(),legetstat(),lesetstat(),lereset(),
	lesetinput();
#define lename "le"
#endif

#include <bwtwo.h>
#if NBWTWO > 0
extern int bwtwoopen(), bwtwommap(), bwtwoclose(), bwtwogetstat(),
	bwtwosetstat();
#define bwtwoname "bwtwo"
#endif

#include <cgfour.h>
#if NCGFOUR > 0
extern int cgfouropen(), cgfourmmap(), cgfourclose(), cgfourgetstat(),
	cgfoursetstat();
#define cgfourname "cgfour"
#endif

#include <cgtwo.h>
#if NCGTWO > 0
extern int cgtwoopen(), cgtwommap(), cgtwoclose(), cgtwogetstat(),
	cgtwosetstat();
#define cgtwoname "cgtwo"
#endif

#include <kb.h>
#if NKB > 0
extern int kbdopen(), kbdinput(), kbdfreset();
#define kbdname "kbtran"
#endif

/*
 * List of devices - console must be at slot 0 and null at 1
 */
struct dev_ops	dev_name_list[] =
{
	/*name,		open,		close,		read,
	  write,	getstat,	setstat,	mmap,
	  async_in,	reset,		port_death,	subdev,
	  dev_info */

	{ cnname,	cnopen,		cnclose,	cnread,
	  cnwrite,	cngetstat,	cnsetstat,	nodev,
	  nodev,	nulldev,	cnportdeath,	0,
	  nodev },

	{ "null",	nulldev,	nulldev,	nulldev,
	  nulldev,	nulldev,	nulldev,	nodev,
	  nodev,	nulldev,	nulldev,	0,
	  nodev },

	{ timename,	timeopen,	timeclose,	nulldev,
	  nulldev,	nulldev,	nulldev,	timemmap,
	  nodev,	nulldev,	nulldev,	0,
	  nodev },

#if NKB > 0
	{ kbdname,	kbdopen,	nodev,		nodev,
	  nodev,	nodev,		nodev,		nodev,
	  kbdinput,	kbdfreset,	nodev,		0,
	  nodev },
#endif 

#if	NXY > 0
	{ xyname,	xyopen,		nulldev,	xyread,
	  xywrite,	xygetstat,	nulldev,	block_io_mmap,
	  nodev,	nulldev,	nulldev,	8,
	  nodev },
#endif

#if NSD > 0
	{ sdname,	sdopen,		nulldev,	sdread,
	  sdwrite,	sdgetstat,	nulldev,	block_io_mmap,
	  nodev,	nulldev,	nulldev,	8,
	  nodev },
#endif

#if NZS > 0
	{ zsname,	zsopen,		zsclose,	zsread,
	  zswrite,	zsgetstat,	zssetstat,	nodev,
	  nodev,	nulldev,	zsportdeath,	0,
	  nodev },
#endif


#if NIE > 0
	{ iename,	ieopen,		nulldev,	nodev,
	  ieoutput,	iegetstat,	iesetstat,	nodev,
	  iesetinput,	iereset,	nulldev,	0,
	  nodev },
#endif

#if NLE > 0
	{ lename,	leopen,		nulldev,	nodev,
	  leoutput,	legetstat,	lesetstat,	nodev,
	  lesetinput,	lereset,	nulldev,	0,
	  nodev },
#endif

#if NBWTWO > 0
	{ bwtwoname,	bwtwoopen,	bwtwoclose,	nodev,
	  nodev,	bwtwogetstat,	bwtwosetstat,	bwtwommap,
	  nodev,	nulldev,	nulldev,	0,
	  nodev },
#endif

#if NCGFOUR > 0
	{ cgfourname,	cgfouropen,	cgfourclose,	nodev,
	  nodev,	cgfourgetstat,	cgfoursetstat,	cgfourmmap,
	  nodev,	nulldev,	nulldev,	0,
	  nodev },
#endif

#if NCGTWO > 0
	{ cgtwoname,	cgtwoopen,	cgtwoclose,	nodev,
	  nodev,	cgtwogetstat,	cgtwosetstat,	cgtwommap,
	  nodev,	nulldev,	nulldev,	0,
	  nodev },
#endif

};
int	dev_name_count = sizeof(dev_name_list)/sizeof(dev_name_list[0]);

/*
 * Indirect list.
 */
struct dev_indirect dev_indirect_list[] = {

	{ "console",	&dev_name_list[0],	0 },
	{ "kbd",	&dev_name_list[1],	0 },
	{ "mouse",	&dev_name_list[1],	0 },
	{ "fb",		&dev_name_list[1],	0 },
};
int	dev_indirect_count = sizeof(dev_indirect_list)
				/sizeof(dev_indirect_list[0]);
