/* 
 * Mach Operating System
 * Copyright (c) 1992 Carnegie Mellon University
 * All Rights Reserved.
 * 
 * Permission to use, copy, modify and distribute this software and its
 * documentation is hereby granted, provided that both the copyright
 * notice and this permission notice appear in all copies of the
 * software, derivative works or modified versions, and any portions
 * thereof, and that both notices appear in supporting documentation.
 * 
 * CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
 * CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
 * ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 * 
 * Carnegie Mellon requests users of this software to return to
 * 
 *  Software Distribution Coordinator  or  Software.Distribution@CS.CMU.EDU
 *  School of Computer Science
 *  Carnegie Mellon University
 *  Pittsburgh PA 15213-3890
 * 
 * any improvements or extensions that they make and grant Carnegie Mellon 
 * the rights to redistribute these changes.
 */
/*
 * HISTORY
 * $Log:	pmap.h,v $
 * Revision 2.7  92/03/31  15:18:30  rpd
 * 	Removed pmap_remove_attributes.
 * 	[92/03/25            rpd]
 * 
 * Revision 2.6  91/07/31  18:14:20  dbg
 * 	Separated user and kernel cases of PMAP_ACTIVATE
 * 	and PMAP_DEACTIVATE.
 * 	[91/07/30  17:18:36  dbg]
 * 
 * Revision 2.5  90/09/09  14:33:50  rpd
 * 	Use decl_simple_lock_data.
 * 	[90/08/30            rpd]
 * 
 * Revision 2.4  90/06/02  15:07:14  rpd
 * 	Added null PMAP_CONTEXT definition.
 * 	[90/03/26  23:00:40  rpd]
 * 
 * Revision 2.3  90/01/22  23:08:52  af
 * 	Added pmap_attribute() [does nothing].
 * 	[89/12/09  12:07:27  af]
 * 
 * Revision 2.2  89/08/31  16:19:33  rwd
 * 	Picked up from rfr.
 * 	[89/08/15            rwd]
 * 
 * Revision 2.6  89/03/09  21:37:27  rpd
 * 	More cleanup.
 * 
 * Revision 2.5  89/02/25  19:46:45  gm0w
 * 	Added new copyright, fixed includes, and removed else leg
 * 	of CMU and MACH conditionals as part of kernel cleanup.
 * 	[89/02/10            jjc]
 * 
 * Revision 2.4  89/01/15  16:33:19  rpd
 * 	Updated includes to the new style.
 * 	Updated macros to the new style.
 * 	Use decl_simple_lock_data.
 * 	[89/01/15  15:13:52  rpd]
 * 
 *  3-Feb-88  Robert Baron (rvb) at Carnegie-Mellon University
 *	Revised for dbg's new pmap.c
 *
 * 19-Jun-86  Jonathan J. Chew (jjc) at Carnegie-Mellon University
 *	Created for Sun 3.
 *
 */

#ifndef	SUN3_PMAP_H_
#define SUN3_PMAP_H_	1

#ifndef	ASSEMBLER

#include <kern/zalloc.h>
#include <kern/lock.h>
#include <sun3/mmu.h>
#include <mach/sun3/vm_param.h>
#include <mach/vm_statistics.h>

/*
 * Sun 3 hardware page table entry
 */

struct pme {
	unsigned int	valid:1;	/* valid bit */
	unsigned int	prot:2;		/* access protection */
	unsigned int	nocache:1;	/* no cache bit */
	unsigned int	type:2;		/* page type */
	unsigned int	ref:1;		/* referenced */
	unsigned int	modify:1;	/* modified */
	unsigned int	:4;
	unsigned int	wired:1;	/* wired down */
	unsigned int	pfn:19;		/* page frame number */
};

typedef struct pme	pme_t;		/* Mach page table entry */

#endif	ASSEMBLER

#define PG_V		0x80000000	/* page is valid */
#define PG_PROT		0x60000000	/* access protection mask */
#define PG_W		0x40000000	/* write enable bit */
#define PG_S		0x20000000	/* system page */
#define PG_NC		0x10000000	/* no cache bit */
#define PG_TYPE		0x0C000000	/* page type mask */
#define PG_R		0x02000000	/* page referenced bit */
#define PG_M		0x01000000	/* page modified bit */
#define PG_MR		0x03000000	/* mask above two bits */
#define PG_PFNUM	0x0C07FFFF	/* page # mask */

#define PG_KW		(PG_S|PG_W)
#define PG_KR		PG_S
#define PG_UW		PG_W		/* kernel can still access */
#define PG_UWKW		PG_UW
#define PG_UR		0		/* kernel can still access */
#define PG_URKR		PG_UR
#define PG_UPAGE	PG_KW		/* sun3 u pages not user accessable */

#define PGT_MASK	(3<<26)

#define PGT_OBMEM	(0<<26)		/* onboard memory */
#define PGT_OBIO	(1<<26)		/* onboard I/O */
#define PGT_VME_D16	(2<<26)		/* VMEbus 16-bit data */
#define PGT_VME_D32	(3<<26)		/* VMEbus 32-bit data */

#define EPA_OBMEM	0x00000000	/* onboard memory */
#define EPA_OBIO	0x10000000	/* onboard I/O */
#define EPA_VME_D16	0x20000000	/* VMEbus 16-bit data */
#define EPA_VME_D32	0x30000000	/* VMEbus 32-bit data */
#define EPA_NC		0x40000000	/* no cache bit */
#define EPA_XTYPE	0x70000000	/* cache and mem type */
#define EPA_TYPE	0x30000000	/* mem type */
#define EPA_F		0x80000000	/* Nibble is really 0xf */
#define EPA_NBL		0xf0000000	/* top nibble mask */

#define PAGE_OBMEM	0		/* pme->type is main memory */

#define pme_mr(x)	( ( x & PG_MR) >> 24)

#ifndef	ASSEMBLER
#include <kern/macro_help.h>

/*
 * Pmap stuff
 */
struct pmap_cache {
	int cache[NPMEG];
};

typedef struct pmap_cache * pmap_cache_t;

struct pmap {
	struct context		*context;	/* ptr. to current context */
	int			ref_count;	/* reference count */
	decl_simple_lock_data(,	lock)		/* lock on map */
	struct pmap_statistics	stats;		/* map statistics */
						/* NOTE: we depend on
						   stats->wired_count being
						   accurate to lock/unlock
						   contexts! */
	int		cache_idx;		/* next available slot */
	int		cache_max;		/* size of cache */
	pmap_cache_t	cache_ptr;		/* remember pmeg's given to
						   this pmap */
};

typedef struct pmap		*pmap_t;
#define PMAP_NULL		((pmap_t) 0)
#define PMAP_CACHE_NULL		((pmap_cache_t) 0)
#define	PMAP_CACHE_INIT_SIZE	8

#define pmap_cache_validate(pmap) 					\
{									\
	if (pmap->cache_ptr == PMAP_CACHE_NULL) {			\
		pmap->cache_idx = 0;					\
		pmap->cache_max = PMAP_CACHE_INIT_SIZE;			\
		pmap->cache_ptr = (pmap_cache_t)			\
			       kalloc(PMAP_CACHE_INIT_SIZE*sizeof(int));\
	} else if (pmap->cache_idx >= pmap->cache_max) {		\
		vm_offset_t oldptr  = (vm_offset_t) pmap->cache_ptr;	\
		int	    oldmax = pmap->cache_max;			\
		pmap->cache_max = pmap->cache_idx * 2;			\
		pmap->cache_ptr  = (pmap_cache_t)			\
				    kalloc(pmap->cache_max*sizeof(int));\
		bcopy((char *)oldptr,(char *)pmap->cache_ptr, 		\
		      oldmax*sizeof(int));				\
		kfree(oldptr, oldmax*sizeof(int));			\
	}								\
}

#define pmap_cache_invalidate(pmap) 					\
{									\
	if (pmap->cache_ptr != PMAP_CACHE_NULL) {			\
		kfree((vm_offset_t)pmap->cache_ptr, 			\
		      pmap->cache_max*sizeof(int));			\
	}								\
	pmap->cache_idx = 0;						\
	pmap->cache_max = 0;						\
	pmap->cache_ptr = PMAP_CACHE_NULL;				\
}

extern pmap_t	kernel_pmap;

zone_t		pmap_zone;		/* zone for more pv_entries */

#ifdef	KERNEL
extern vm_offset_t	phys_map_vaddr1,
			phys_map_vaddr2;

extern queue_head_t	context_active_queue;
extern int		context_active_count;

/*
 *	Macros for speed
 */
#define	PMAP_ACTIVATE_KERNEL(cpu)
#define	PMAP_DEACTIVATE_KERNEL(cpu)

#define PMAP_ACTIVATE_USER(pmap, th, cpu)				\
MACRO_BEGIN								\
	if ((pmap) != kernel_pmap) {					\
		if ((pmap)->context == 0)				\
			context_allocate(pmap);				\
		remqueue(&context_active_queue,				\
			 (queue_entry_t) (pmap)->context);		\
		context_active_count--;					\
		setcontext((pmap)->context->num);			\
	}								\
	else								\
		setcontext(KCONTEXT);					\
MACRO_END

#define PMAP_DEACTIVATE_USER(pmap, th, cpu)				\
MACRO_BEGIN								\
	if ((pmap) != kernel_pmap) {					\
		enqueue_tail(&context_active_queue,			\
			     (queue_entry_t) (pmap)->context);		\
		context_active_count++;					\
	}								\
MACRO_END


struct	context {
	queue_chain_t	link;		/* link in active or free queues */
	pmap_t		pmap;		/* pmap this context is allocated to */
	int		num;		/* context number for hardware */
};

#define pmap_resident_count(pmap)	((pmap)->stats.resident_count)
#define pmap_attribute(pmap,addr,size,attr,val)	KERN_INVALID_ARGUMENT

/*
 *	Initialize (head of) pv list
 */

#endif	KERNEL
#endif	ASSEMBLER
#endif	SUN3_PMAP_H_
