/*
 * Copyright (c) 1989 by Apollo Computer, Inc.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation.
 *
 * This file is provided AS IS with no warranties of any kind.  The authors
 * shall have no liability with respect to the infringement of copyrights,
 * trade secrets or any patents by this file or any part thereof.  In no
 * event will the authors be liable for any lost revenue or profits or
 * other special, indirect and consequential damages.
 *
 * Copyright (c) 1989 Carnegie-Mellon University
 * Copyright (c) 1988 Carnegie-Mellon University
 * Copyright (c) 1987 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 *
 *
 * Bug reports/fixes, comments and enhancements should be sent to:
 *       nawaf@osf.org
 *       Nawaf Bitar
 *       Open Software Foundation
 *       11 Cambridge Center
 *       Cambridge, MA 02142
 *
 * Contributors:  Nawaf Bitar
 *		  Tom Lemaire
 *		  Vidas Neverauskas
 *		  Ed Sharpe
 *
 */

#ifndef	_PMAP_MACHINE_
#define	_PMAP_MACHINE_
#ifndef	ASSEMBLER

#include "machine/machparam.h"
#include "kern/lock.h"
#include "mach/vm_statistics.h"
#include "sys/vmmac.h"

/* l1_ptr_t is actually opaque to machine independent modules */
typedef struct l1_entry *l1_ptr_t;

/*
 * PMAP structure.
 */
typedef struct pmap *pmap_t;

struct pmap {
	l1_ptr_t		lvl1_paddr;	/* phys ptr to lvl1 table	*/
	l1_ptr_t		lvl1_vaddr;	/* virt ptr to lvl1 table	*/
	int			ref_count;	/* reference count		*/
#ifdef	DBG
	pmap_t 			next;
	pmap_t 			prev;
#endif	DBG
	simple_lock_data_t	lock;		/* lock on map			*/
	struct pmap_statistics	stats;		/* map statistics		*/
};

#define	PMAP_NULL ((pmap_t) 0)

/*
 * External declaration for PMAP_ACTIVATE.
 */
#define PMAP_ACTIVATE(pmap, th, my_cpu)	{		\
	struct pcb *pcb = thread_pcb(th);		\
	pcb->crp_regs = (vm_offset_t)pmap->lvl1_paddr;	\
}

#define PMAP_DEACTIVATE(pmap, thread, cpu)

#define PMAP_CONTEXT(pmap, new_thread) {                \
        struct pcb *pcb = thread_pcb(new_thread);	\
	pcb->crp_regs = (vm_offset_t)pmap->lvl1_paddr;	\
}


#define	pmap_resident_count(pmap)	((pmap)->stats.resident_count)
/* XXX should we define and use apollo_btop and apollo_ptob in next two macros? */
#define	pmap_phys_address(frame)	((vm_offset_t) (ptob(frame)))
#define pmap_phys_to_frame(phys)        ((int) (btop(phys)))

#endif	ASSEMBLER
#endif	_PMAP_MACHINE_
