/* 
 * Mach Operating System
 * Copyright (c) 1990 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * HISTORY
 * $Log:	bsd_mman.c,v $
 * Revision 2.2  90/09/08  00:14:32  rwd
 * 	First Checkin
 * 
 */
/*
 *	File:	./bsd_mman.c
 *	Author:	Joseph S. Barrera III, Randall W. Dean
 *
 *	Copyright (c) 1990 Joseph S. Barrera III, Randall W. Dean
 */

#include <mach.h>
#include <errno.h>
#include <ux_user.h>

Bsd_sbrk(ut, rval, size)
	struct ux_task *ut;
	int rval[2];
	int size;
{
	int error;

	size = round_page(size);
	if (size > 0) {
		error = vm_allocate(ut->ut_task, &ut->ut_break, size, FALSE);
		if (error) {
			/* XXX should do a vm_region to see what's up */
			mach_error("sbrk: vm_allocate", error);
			return ENOMEM;
		}
	}
	rval[0] = ut->ut_break;
	ut->ut_break += size;
	return 0;

}

Bsd_obreak(ut, rval, new_addr)
	struct ux_task *ut;
	int rval[2];
	vm_offset_t new_addr;
{
	int error;

	new_addr = round_page(new_addr);
	if (new_addr <= ut->ut_break) {
		return 0;
	}
	error = vm_allocate(ut->ut_task, &ut->ut_break,
			    new_addr - ut->ut_break, FALSE);
	if (error) {
		/* XXX should do a vm_region to see what's up */
		mach_error("obreak: vm_allocate", error);
		return ENOMEM;
	}
	ut->ut_break = new_addr;
	return 0;
}

Bsd_getpagesize(ut, rval)
	struct ux_task *ut;
	int rval[2];
{
#if	vax
	rval[0] = 1024;
#else
	rval[0] = vm_page_size;
#endif
	return 0;
}
