/* 
 * Mach Operating System
 * Copyright (c) 1990 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * HISTORY
 * $Log:	loader_info.h,v $
 * Revision 2.2  90/09/08  00:19:08  rwd
 * 	First checkin
 * 	[90/08/31  13:51:53  rwd]
 * 
 */
/*
 *	File:	./loader_info.h
 *	Author:	Joseph S. Barrera III, Randall W. Dean
 *
 *	Copyright (c) 1990 Joseph S. Barrera III, Randall W. Dean
 */

/*
 *	Data structures for bootstrap program loader.
 */

struct loader_info {
	int		format;		/* load format */
	vm_offset_t	text_start;	/* text start in memory */
	vm_size_t	text_size;
	vm_offset_t	text_offset;	/* text offset in file */
	vm_offset_t	data_start;	/* data+bss start in memory */
	vm_size_t	data_size;
	vm_offset_t	data_offset;	/* data offset in file */
	vm_size_t	bss_size;
	vm_offset_t	entry_1;	/* 2 words for entry address */
	vm_offset_t	entry_2;
} ;
/* values for format */
#define	EX_UNKNOWN	0		/* ? */
#define	EX_READIN	1		/* 0407 */
#define	EX_SHAREABLE	2		/* 0410 */
#define	EX_PAGEABLE	3		/* 0413 */

