/* Written by MIB */

/* C library functions used by poe */

#include <config.h>
#include <mach.h>
#include <device/device_types.h>
#include <varargs.h>

port_t device_server_port;
port_t console_port;

static _internal_printf(), printn();

init_console()
{
  device_open (device_server_port, D_READ|D_WRITE, "console",
	       &console_port);
}

cnputc (foo, c)
     int foo, c;
{
  char outc = c;
  int n;
  char nl[] = "\r\n";
  
  if (c == '\n')
    device_write_inband (console_port, 0, 0, nl, 2, &n);
  else
    device_write_inband (console_port, 0, 0, &outc, 1, &n);
}


/* Find the first ocurrence of C in S.  */
char *
index (s, c)
     char *s;
     int c;
{
  register char *p = s;
  register int x = (unsigned char) c;

  while (*p != '\0')
    if (*p == x)
      return (char *) p;
    else
      ++p;

  return x == '\0' ? (char *) p : 0;
}

char *
calloc (nelem, size)
     int nelem, size;
{
  vm_address_t ret = 0;
  
  if (vm_allocate (mach_task_self (), &ret, size * nelem, 1)
      == KERN_SUCCESS)
    {
      bzero (ret, nelem * size);
      return (char *) ret;
    }
  else
    return 0;
}


/* Printf functions.  Ick. */

printf (va_alist)
     va_dcl
{
  va_list ap;
  char *fmt;

  va_start (ap);
  fmt = va_arg (ap, char *);
  _internal_printf (fmt, ap, cnputc, 0);
  va_end (ap);
}

_internal_strappend (str, c)
     char **str, c;
{
  *(*str)++ = c;
}

sprintf (va_alist)
     va_dcl
{
  va_list ap;
  char *str, *fmt;
  
  va_start (ap);
  str = va_arg (ap, char *);
  fmt = va_arg (ap, char *);
  _internal_printf (fmt, ap, _internal_strappend, &str);
  va_end (ap);
}



/* A simplified version of library routine; this just handles % specs, */
 /* without handling #, -, +, etc.  It also doesn't do floats of any */
 /* sort. */
static
_internal_printf(control, args, outfun, outarg)
     char *control;
     va_list args;
     int (*outfun)(), outarg;
{
  int c, i, base, u;
  char *s;

loop:
  while ((c = *control++) != '%')
    if (c == '\0')
      return;
    else
      (*outfun)(outarg, c);
  
  switch (*control++)
    {
    case 'u':
      base = 10;
      u = 1;
      goto number;
    case 'd':
      base = 10;
      u = 0;
      goto number;
    case 'o':
      base = 8;
      u = 1;
      goto number;
    case 'x':
      u = 1;
      base = 16;
    number:
      printn(va_arg(args, unsigned long), base, u, outfun, outarg);
      break;
    case 'c':
      for (i = 24; i >= 0; i -= 8)
	if (c = (va_arg(args, char) >> i) & 0x7f)
	  (*outfun)(outarg, c);
    case 's':
      s = (char *)va_arg(args, char *);
      while (c = *s++)
	(*outfun)(outarg, c);
      break;
    case '%':
      (*outfun)(outarg, '%');
      break;
    }
  goto loop;
}


/* Print a number */
static
printn(n, b, u, of, oa)
     unsigned long n;
     int b, u;
     int (*of)(), oa;
{
  char prbuf[11];
  register char *cp;
  
  if (u && (int)n < 0)
    {
      (*of)(oa, '-');
      n = (unsigned)(-(int)n);
    }
  cp = prbuf;
  do
    {
      *cp++ = "0123456789abcdef"[n%b];
      n /= b;
    }
  while (n);
  do
    (*of)(oa, *--cp);
  while (cp > prbuf);
}

  

    
