/*--------------------------- fft1.c ---------------------------------- */
/*									*/
/* Author:	Eyal Lebedinsky						*/
/* Date:	May 1990						*/
/* Version:	31 August 1991						*/
/*									*/
/* Measure the fft() time. NOTE that on UNIX and other multiprogramming	*/
/* systems you will need to replace time() with a cpu timing function.	*/
/*									*/
/*--------------------------------------------------------------------- */

#include <stdio.h>
#include <stdlib.h>
#include <time.h>

extern void FAR fft ();

#define N 256

short		NEAR x[N] = {0};
short		NEAR qf[N/2+1] = {0};
static short	xx[N];

static void
test_once (flag)
int	flag;
{
	memcpy (x, xx, sizeof (x));
	if (flag)
		fft();
}

static long
test_all (flag, l)
int	flag;
long	l;
{
	long	t;

	t = time (0);
	while (--l)
		test_once (flag);

	return (time (0) - t);
}

main()
{
	long	i, t1, t2;

	for (i = 0; i < N; ++i)
		xx[i] = 1024 * (i % 32);	/* saw-tooth */

	for (i = 100L;;) {
		printf ("fft1> trying %ld times, ", i);
		t1 = test_all (1, i);
		t1 -= (t2 = test_all (0, i));
		if (t1 >= 50L)
			break;
		if (t1 < 4)
			i *= 5L;
		else
			i = (i * 50L) / (t1 - 1);
		printf ("too fast (only %ld+%ld seconds)\n", t1, t2);
	}
	printf ("good (%ld+%ld seconds)\n", t1, t2);

	printf ("fft1> time per fft(): ");
	t2 = (t1 * 10000L) / i;
	if (t2 > 100)
		printf ("%ld.%ld millisec\n", t2 / 10, t2 % 10);
	else {
		t2 = (t1 * 1000000L) / i;
		printf ("%ld microsec\n", t2);
	}

	exit (0);
}
