/* ------------------------- fftouts.c -------------------------------- */
/*									*/
/* Author:	Eyal Lebedinsky						*/
/* Date:	May 1990						*/
/* Version:	9 June 1991						*/
/*									*/
/* called from fftg.c and generates ns32k .s				*/
/*									*/
/* This program is released into the public domain.			*/
/*									*/
/*----------------------------------------------------------------------*/

#include <stdio.h>

static int	label = 0;

void
start_fft (file_name, ep_name)
char	*file_name, *ep_name;
{
	char	fname[256];

	strcpy (fname, file_name);
	strcat (fname, ".s");

	freopen (fname, "wt", stdout);
	printf (" .text\n");
	printf (" .align 2\n");
	printf (" .globl _%s\n", ep_name);
	printf ("_%s:\n", ep_name);
	printf (" enter [r3,r4,r5,r6,r7],0\n");
}

void
end_fft (file_name, ep_name)
char	*file_name, *ep_name;
{
	printf (" exit [r7,r6,r5,r4,r3]\n");
	printf (" ret 0\n");
	close (stdout);
}

static void
mulf (from, to, cc)
int	from, to, cc;
{
	printf (" cmpqw 0,r%d\n", from);
	printf (" absw  r%d,r%d\n", from, to-1);
	if (cc >= 0) {
		printf (" meiw  %d,r%d\n", cc, to-1);
		printf (" blt   l%d\n", ++label);
	} else {
		printf (" meiw  %d,r%d\n", -cc, to-1);
		printf (" bgt   l%d\n", ++label);
	}
	printf (" negw  r%d,r%d\n", to, to);
	printf ("l%d:\n", label);
}

void
fft1 (i1)
int	i1;
{
/* x[i] = x[i] >> 1; */
	printf (" ashw -1,_x+%u(pc)\n", 2*i1);
}

void
fft2 (i1, i2)
int	i1, i2;
{
/* t1 = x[i1] >> 1; */
	printf (" movw _x+%u(pc),r1\n", 2*i1);
	printf (" ashw -1,r1\n");
	printf (" movw _x+%u(pc),r2\n", 2*i2);
	printf (" ashw -1,r2\n");
/* x[i1] = t1 + (x[i2] >> 1); */
	printf (" movw r1,r0\n");
	printf (" addw r2,r0\n");
	printf (" movw r0,_x+%u(pc)\n", 2*i1);
/* x[i2] = t1 - (x[i2] >> 1); */
	printf (" subw r2,r1\n");
	printf (" movw r1,_x+%u(pc)\n", 2*i2);
}

void
fft3 (i1, i3, i4)
int	i1, i3, i4;
{
/* x[i4] = ((x[i4] >> 1) - (x[i3] >> 1)) >> 1; */
	printf (" movw _x+%u(pc),r4\n", 2*i4);
	printf (" ashw -1,r4\n");
	printf (" movw _x+%u(pc),r3\n", 2*i3);
	printf (" ashw -1,r3\n");
	printf (" movw r4,r0\n");
	printf (" subw r3,r0\n");
	printf (" ashw -1,r0\n");
	printf (" movw r0,_x+%u(pc)\n", 2*i4);
/* t1	= ((x[i4] >> 1) + (x[i3] >> 1)) >> 1; */
	printf (" addw r3,r4\n");
	printf (" ashw -1,r4\n");		/* r4 = t1 */
/* x[i3] =  (x[i1] >> 1) - t1; */
	printf (" movw _x+%u(pc),r1\n", 2*i1);
	printf (" ashw -1,r1\n");
	printf (" movw r1,r0\n");
	printf (" subw r4,r0\n");
	printf (" movw r0,_x+%u(pc)\n", 2*i3);
/* x[i1] =  (x[i1] >> 1) + t1 */
	printf (" addw r4,r1\n");
	printf (" movw r1,_x+%u(pc)\n", 2*i1);
}

void
fft4 (i1, i2, i3, i4, cc1)
int	i1, i2, i3, i4, cc1;
{
/* t3 = mulf (x[i3], cc1); */
	printf (" movw _x+%u(pc),r2\n", 2*i3);
	mulf (2, 3, cc1);
/* t4 = mulf (x[i4], cc1); */
	printf (" movw _x+%u(pc),r5\n", 2*i4);
	mulf (5, 5, cc1);			/* result in r5 = t4 */
/* tt2 = t3 - t4; */
	printf (" movw r3,r0\n");
	printf (" subw r5,r3\n");		/* r3 = tt2 */
/* tt1 = t3 + t4; */
	printf (" addw r0,r5\n");		/* r5 = tt1 */

	printf (" movw _x+%u(pc),r1\n", 2*i1);
	printf (" ashw -2,r1\n");		/* r1 = x[i1] */
	printf (" movw _x+%u(pc),r2\n", 2*i2);
	printf (" ashw -1,r2\n");		/* r2 = x[i2] */
/* x[i3] = -(x[i2] >> 1) - t1; */
	printf (" negw r5,r0\n");		/* - tt1 */
	printf (" subw r2,r0\n");		/* -x[i2] - tt1 */
	printf (" movw r0,_x+%u(pc)\n", 2*i3);
/* x[i4] =  (x[i2] >> 1) - t1; */
	printf (" subw r5,r2\n");		/* x[i2] - tt1 */
	printf (" movw r2,_x+%u(pc)\n", 2*i4);
/* x[i2] =  (x[i1] >> 2) - t2; */
	printf (" movw r1,r0\n");		/* x[i1] */
	printf (" subw r3,r0\n");		/* x[i1] - tt2 */
	printf (" movw r0,_x+%u(pc)\n", 2*i2);
/* x[i1] =  (x[i1] >> 2) + t2; */
	printf (" addw r3,r1\n");		/* x[i1] + tt2 */
	printf (" movw r1,_x+%u(pc)\n", 2*i1);
}

void
fft5 (i1, i2, i3, i4, i5, i6, i7, i8, sm1, sp1, cc1, sm3, sp3, cc3, ind)
int	i1, i2, i3, i4, i5, i6, i7, i8, sm1, sp1, cc1, sm3, sp3, cc3, ind;
{
/* t5 = x[i7]; */
	printf (" movw _x+%u(pc),r5\n", 2*i7);		/* t5 = r5 */
/* t1 = mulf (t5, sm1); */
	mulf (5, 1, sm1);				/* t1 = r1 ***/
/* t6 = x[i3]; */
	printf (" movw _x+%u(pc),r6\n", 2*i3);		/* t6 = r6 */
/* if (ind) */
/*   t6 >>= 1; */
	if (ind)
		printf (" ashw -1,r6\n");
/* t5 += t6; */
	printf (" addw r6,r5\n");
/* t2 = mulf (t6, sp1); */
	mulf (6, 7, sp1);				/* t2 = r7 */
/* t5 = mulf (t5, cc1); */
	mulf (5, 5, cc1);				/* t5 = r5 */
/* t1 += t5; */
	printf (" addw r5,r1\n");			/* t1 = r1 */
/* t2 += t5; */
	printf (" addw r5,r7\n");
	printf (" movw r7,r0\n");			/* t2 = r0 ***/

/* t5 = x[i8]; */
	printf (" movw _x+%u(pc),r5\n", 2*i8);		/* t5 = r5 */
/* t3 = mulf (t5, sm3); */
	mulf (5, 3, sm3);				/* t3 = r3 ***/
/* t6 = x[i4]; */
	printf (" movw _x+%u(pc),r6\n", 2*i4);		/* t6 = r6 */
/* if (ind) */
/*   t6 >>= 1; */
	if (ind)
		printf (" ashw -1,r6\n");
/* t5 += t6; */	
	printf (" addw r6,r5\n");
/* t4 = mulf (t6, sp3); */
	mulf (6, 7, sp3);				/* t4 = r7 */
/* t5 = mulf (t5, cc3); */
	mulf (5, 5, cc3);
/* t3 += t5; */
	printf (" addw r5,r3\n");
/* t4 += t5; */
	printf (" addw r7,r5\n");			/* t4 = r5 ***/

				/* t= 1 2 3 4 5 6 */
				/* r= 1 0 3 5 7 6 */
/* t5 = t3 - t1; */
	printf (" movw r3,r7\n");
	printf (" subw r1,r7\n");
/* t6 =  x[i2] >> 1; */
	printf (" movw _x+%u(pc),r6\n", 2*i2);
	printf (" ashw -1,r6\n");
/* x[i7] = t5 - t6; */
	printf (" movw r7,r2\n");
	printf (" subw r6,r2\n");
	printf (" movw r2,_x+%u(pc)\n", 2*i7);
/* x[i4] =  t5 + t6; */
	printf (" addw r6,r7\n");
	printf (" movw r7,_x+%u(pc)\n", 2*i4);
/* t5 = t2 + t4;*/
	printf (" movw r0,r7\n");
	printf (" addw r5,r7\n");
/* t6	=  x[i6] >> 1; */
	printf (" movw _x+%u(pc),r6\n", 2*i6);
	printf (" ashw -1,r6\n");
/* x[i3] = t5 - t6; */
	printf (" movw r7,r2\n");
	printf (" subw r6,r2\n");
	printf (" movw r2,_x+%u(pc)\n", 2*i3);
/* x[i8] = t5 + t6;*/
	printf (" addw r6,r7\n");
	printf (" movw r7,_x+%u(pc)\n", 2*i8);
/* t5 = t1 + t3; */
	printf (" movw r1,r7\n");
	printf (" addw r3,r7\n");
/* t6    =  x[i1] >> 1; */
	printf (" movw _x+%u(pc),r6\n", 2*i1);
	printf (" ashw -1,r6\n");
/* x[i6] = t6 - t5; */
	printf (" movw r6,r2\n");
	printf (" subw r7,r2\n");
	printf (" movw r2,_x+%u(pc)\n", 2*i6);
/* x[i1] = t5 + t6; */
	printf (" addw r6,r7\n");
	printf (" movw r7,_x+%u(pc)\n", 2*i1);
/* t5 = t2 - t4; */
	printf (" movw r0,r7\n");
	printf (" subw r5,r7\n");
/* t6 = x[i5] >> 1; */
	printf (" movw _x+%u(pc),r6\n", 2*i5);
	printf (" ashw -1,r6\n");
/* x[i5] = t6 - t5; */
	printf (" movw r6,r2\n");
	printf (" subw r7,r2\n");
	printf (" movw r2,_x+%u(pc)\n", 2*i5);
/* x[i2] = t5 + t6; */
	printf (" addw r6,r7\n");
	printf (" movw r7,_x+%u(pc)\n", 2*i2);
}

void
fft7 (i1, i2)
int	i1, i2;
{
/* lt1 = x[i2]; */
	printf (" movw _x+%u(pc),r0\n", 2*i2);
/* lt1 *= lt1; */
	printf (" absw r0,r0\n");
	printf (" meiw r0,r0\n");
/* qf[i1] = lt1 >> 16; */
	printf (" movw r1,_qf+%u(pc)\n", 2*i1);
}

void
fft8 (i1, i2, i3)
int	i1, i2, i3;
{
/* lt1 = x[i2]; */
	printf (" movw _x+%u(pc),r0\n", 2*i2);
/* lt1 *= lt1; */
	printf (" absw r0,r0\n");
	printf (" meiw r0,r0\n");
/* lt2 = x[i3]; */
	printf (" movw _x+%u(pc),r2\n", 2*i3);
/* lt2 *= lt2; */
	printf (" absw r2,r2\n");
	printf (" meiw r2,r2\n");
/* qf[i1] = (lt1 + lt2) >> 16; */
	printf (" addw r3,r1\n");
	printf (" movw r1,_qf+%u(pc)\n", 2*i1);
}
