/*
 * Decompiled with CFR 0.152.
 */
package jde.wizards;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import jde.wizards.ClassRegistry;
import jde.wizards.DefaultNameFactory;
import jde.wizards.NameFactory;
import jde.wizards.Signature;

public class MethodFactory
implements ClassRegistry {
    protected Hashtable imports = new Hashtable();
    protected NameFactory namefactory = null;
    private String[] numericTypesArray = new String[]{"char", "byte", "short", "int", "long", "float", "double"};
    private List numericTypesList = Arrays.asList(this.numericTypesArray);

    public MethodFactory() {
        this(new DefaultNameFactory());
    }

    public MethodFactory(NameFactory factory) {
        this.namefactory = factory;
    }

    public void setNameFactory(NameFactory factory) {
        this.namefactory = factory;
    }

    public NameFactory getNameFactory() {
        return this.namefactory;
    }

    public Hashtable getImports() {
        return this.imports;
    }

    public String getImportsAsList() {
        StringBuffer res = new StringBuffer("(list ");
        Enumeration i = this.imports.keys();
        while (i.hasMoreElements()) {
            Class c = (Class)i.nextElement();
            res.append("\"" + c.getName() + "\" ");
        }
        res.append(")");
        return res.toString();
    }

    public void registerImport(Class register) {
        if (register.isArray()) {
            try {
                Class<?> cl = register;
                while (cl.isArray()) {
                    cl = cl.getComponentType();
                }
                register = cl;
            }
            catch (Throwable t) {
                throw new RuntimeException("Caught error walking up an Array object: " + t);
            }
        }
        if (this.shouldImport(register)) {
            this.imports.put(register, "");
        }
    }

    private final boolean shouldImport(Class c) {
        if (c.isPrimitive()) {
            return false;
        }
        String name = c.getName();
        if (name.startsWith("java.lang")) {
            char[] n = name.toCharArray();
            int i = 10;
            while (i < n.length) {
                if (n[i] == '.') {
                    return true;
                }
                ++i;
            }
            return false;
        }
        return true;
    }

    protected String getDefaultBody(Signature sig) {
        Method m = sig.getMethod();
        Class<?> cl = m.getReturnType();
        if (this.numericTypesList.contains(cl.getName())) {
            return "return 0;";
        }
        if (cl.getName().equals("boolean")) {
            return "return false;";
        }
        if (!cl.getName().equals("void")) {
            return "return null;";
        }
        return "";
    }

    public String getMethodSkeletonExpression(Signature sig) {
        StringBuffer res = new StringBuffer();
        res.append("(jde-wiz-gen-method");
        res.append(" \"" + sig.getModifiers() + "\"");
        res.append(" \"" + sig.getReturnBaseType() + "\"");
        res.append(" \"" + sig.getMethod().getName() + "\"");
        res.append(" \"" + sig.getParameters() + "\"");
        res.append(" \"" + sig.getExceptionList() + "\"");
        res.append(" \"" + this.getDefaultBody(sig) + "\")\n");
        return res.toString();
    }

    public void flush() {
        this.imports.clear();
    }

    public static void println(String s) {
        System.out.print(s + "\n");
        System.out.flush();
    }
}

