/*
 * Decompiled with CFR 0.152.
 */
package jde.wizards;

import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jde.wizards.DefaultNameFactory;
import jde.wizards.MethodFactory;
import jde.wizards.NameFactory;
import jde.wizards.Signature;

public class DelegateFactory
extends MethodFactory {
    private Hashtable interfaces = new Hashtable();
    static DelegateFactory delegateFactory;
    private String delegee;

    public DelegateFactory() {
    }

    public DelegateFactory(NameFactory factory) {
        super(factory);
    }

    private final void sortByDeclaringClass(Signature sig) {
        String declaring = sig.getDeclaringClass().getName();
        if (this.interfaces.containsKey(declaring)) {
            Vector v = (Vector)this.interfaces.get(declaring);
            if (!v.contains(sig)) {
                v.addElement(sig);
            }
        } else {
            Vector<Signature> v = new Vector<Signature>();
            v.addElement(sig);
            this.interfaces.put(declaring, v);
        }
    }

    public void flush() {
        super.flush();
        this.interfaces.clear();
    }

    public void process(String interfaceName) throws ClassNotFoundException {
        this.process(interfaceName, true);
    }

    public void process(String name, boolean truncate) throws ClassNotFoundException {
        if (null == this.namefactory) {
            this.namefactory = new DefaultNameFactory();
        }
        Class<?> aclass = Class.forName(name);
        Method[] methods = aclass.getMethods();
        int i = 0;
        while (i < methods.length) {
            this.sortByDeclaringClass(new Signature(methods[i], this, truncate, true));
            ++i;
        }
    }

    public static void makeDelegatesExpression(String attributeName, String className, boolean truncate) {
        if (delegateFactory == null) {
            delegateFactory = new DelegateFactory();
        }
        delegateFactory.flush();
        delegateFactory.makeInterfaceExpressionInternal(attributeName, className, truncate);
    }

    private void makeInterfaceExpressionInternal(String attributeName, String className, boolean truncate) {
        this.delegee = attributeName;
        try {
            this.process(className, truncate);
        }
        catch (ClassNotFoundException e) {
            MethodFactory.println("(error \"Error: could not find class named: " + className + ". " + "Note: name must be qualified.\")");
            return;
        }
        catch (Exception e) {
            MethodFactory.println("(error \"Error: unknown type.\")");
            return;
        }
        this.dumpExpression(new PrintWriter(System.out, true), truncate);
    }

    public static void getImportedClasses() {
        MethodFactory.println(delegateFactory.getImportsAsList());
    }

    protected String getDefaultBody(Signature sig) {
        Method m = sig.getMethod();
        Class<?> cl = m.getReturnType();
        String defBody = "";
        defBody = this.delegee + "." + m.getName() + "(" + sig.getParameterNames() + ");";
        if (!cl.getName().equals("void")) {
            defBody = "return " + defBody;
        }
        return defBody;
    }

    public void dumpExpression(PrintWriter out, boolean truncate) {
        StringBuffer buf = new StringBuffer("(jde-wiz-gen-delegation-methods (list ");
        Enumeration declaring_classes = this.interfaces.keys();
        while (declaring_classes.hasMoreElements()) {
            String interf = (String)declaring_classes.nextElement();
            Vector v = (Vector)this.interfaces.get(interf);
            Enumeration e = v.elements();
            boolean isFirst = true;
            while (e.hasMoreElements()) {
                Signature sig = (Signature)e.nextElement();
                if (interf.equals("java.lang.Object") && Modifier.isFinal(sig.getMethod().getModifiers())) continue;
                if (isFirst) {
                    buf.append("(quote ");
                    buf.append("\"Code for delegation of ");
                    buf.append(interf);
                    buf.append(" methods to ");
                    buf.append(this.delegee);
                    buf.append("\")");
                    isFirst = false;
                }
                buf.append("(quote ");
                buf.append(this.getMethodSkeletonExpression(sig));
                buf.append(")");
            }
        }
        buf.append("))");
        MethodFactory.println(buf.toString());
    }
}

