(*^

::[paletteColors = 128; 
	fontset = title, "Geneva", 24, L2, center, bold, nohscroll;
	fontset = subtitle, "Geneva", 18, L2, center, bold, nohscroll;
	fontset = subsubtitle, "Geneva", 14, L2, center, bold, nohscroll;
	fontset = section, "Geneva", 14, L2, bold, nohscroll, grayBox;
	fontset = subsection, "Geneva", 12, L2, bold, nohscroll, blackBox;
	fontset = subsubsection, "Geneva", 10, L2, bold, nohscroll, whiteBox;
	fontset = text, "Geneva", 12, L2, nohscroll;
	fontset = smalltext, "Geneva", 10, L2, nohscroll;
	fontset = input, "Courier", 12, L2, bold, nowordwrap;
	fontset = output, "Courier", 12, L2, nowordwrap;
	fontset = message, "Courier", 12, L2, R65535, nowordwrap;
	fontset = print, "Courier", 12, L2, nowordwrap;
	fontset = info, "Courier", 12, L2, nowordwrap;
	fontset = postscript, "Courier", 12, L2, nowordwrap;
	fontset = name, "Geneva", 10, L2, italic, B65535, nowordwrap, nohscroll;
	fontset = header, "Times", 10, L2;
	fontset = footer, "Times", 12, L2, center;
	fontset = help, "Geneva", 10, L2, nohscroll;
	fontset = clipboard, "New York", 12, L2;
	fontset = completions, "New York", 12, L2, nowordwrap;
	fontset = network, "Courier", 10, L2, nowordwrap;
	fontset = graphlabel, "Courier", 12, L2, nowordwrap;
	fontset = special1, "New York", 12, L2, nowordwrap;
	fontset = special2, "New York", 12, L2, center, nowordwrap;
	fontset = special3, "New York", 12, L2, right, nowordwrap;
	fontset = special4, "New York", 12, L2, nowordwrap;
	fontset = special5, "New York", 12, L2, nowordwrap;]
:[font = title; inactive; ]
Programmed Definition of Functions
:[font = text; inactive; ]
This example comes from section 5.5.
:[font = subsubsection; inactive; locked; startGroup; Cclosed; ]
Copyright Notice
:[font = smalltext; inactive; locked; endGroup; ]

	Copyright 1989 by Roman Maeder.
	
	Adapted from	Roman E. Maeder: Programming in Mathematica, Addison-Wesley, 1989.
	
	Permission is hereby granted to make copies of	this file for any purpose other than direct profit,	or as part of a commercial product, provided this copyright notice is left intact.	Sale, other than for the cost of media, is prohibited.
	
	Permission is hereby granted to reproduce part or all of this file provided that the source is acknowledged.

;[s]
3:0,0;67,1;93,0;470,-1;
2:2,14,10,Geneva,0,10,0,0,0;1,14,10,Geneva,2,10,0,0,0;
:[font = section; inactive; startGroup; Cclosed; ]
Examples
:[font = subsection; inactive; startGroup; Cclosed; ]
The Sign Function
:[font = text; inactive; ]
This is the same as the built-in Sign[].
:[font = input; ]
StepFunction[Signum, -1, 0, 1]
:[font = input; endGroup; ]
Plot[Signum[x], {x, -1, 1}];
:[font = subsection; inactive; startGroup; Cclosed; ]
sub title
:[font = text; inactive; ]
This function increases linearly from -1 to 1 between -1 and 1.
:[font = input; ]
LinearFunction[g, -1, -1, 1, 1]
:[font = input; endGroup; endGroup; ]
Plot[g[x], {-2, 2}];
:[font = section; inactive; startGroup; Cclosed; ]
Implementation
:[font = input; initialization; ]
*)
BeginPackage["RMPackages`MakeFunctions`"]
(*
:[font = input; initialization; ]
*)
StepFunction::usage = "StepFunction[f, a, x0, b] defines rules for f
	such that f[x] = a for x <= x0, f[x] = b for x > x0."
(*
:[font = input; initialization; ]
*)
LinearFunction::usage = "LinearFunction[f, a, x0, x1, b] defines rules for f
	such that f[x] = a for x <= x0, f[x] = b for x >= x1 and
	f increases linearly from a to b between x0 and x1."
(*
:[font = input; initialization; ]
*)
MakeRule::usage = "MakeRule[f, x, rhs]
	globally defines the rule f[x_] := rhs."
(*
:[font = input; initialization; ]
*)
MakeRuleConditional::usage = "MakeRuleConditional[f, x, rhs, cond]
	globally defines the rule f[x_] := rhs /; cond."
(*
:[font = input; initialization; ]
*)
Begin["`Private`"]
(*
:[font = input; initialization; ]
*)
`x	(* used for the dummy variable in the functions defined *)
(*
:[font = input; initialization; ]
*)
SetAttributes[MakeRule, HoldAll]
(*
:[font = input; initialization; ]
*)
MakeRule[f_Symbol, var_Symbol, rhs_] :=
	f[var_] := rhs
(*
:[font = input; initialization; ]
*)
SetAttributes[MakeRuleConditional, HoldAll]
(*
:[font = input; initialization; ]
*)
MakeRuleConditional[f_Symbol, var_Symbol, rhs_, condition_] :=
	(f[var_] := rhs /; condition)
(*
:[font = input; initialization; ]
*)
StepFunction[f_Symbol, a_, x0_, b_] := (
	MakeRuleConditional[f, x, a, x <= x0];
	MakeRuleConditional[f, x, b, x > x0]
	)
(*
:[font = input; initialization; ]
*)
LinearFunction[f_Symbol, a_, x0_, x1_, b_] :=
	Block[{slope = (b-a)/(x1-x0)},
		MakeRuleConditional[f, x, a, x <= x0];
		MakeRuleConditional[f, x, Release[a + (x-x0) slope], x0 < x < x1];
		MakeRuleConditional[f, x, b, x >= x1]
	]
(*
:[font = input; initialization; ]
*)
End[]
(*
:[font = input; initialization; ]
*)
Protect[StepFunction, LinearFunction, MakeRule, MakeRuleConditional]
(*
:[font = input; initialization; endGroup; ]
*)
EndPackage[]
(*
^*)