(*^

::[paletteColors = 128; 
	fontset = title, "Helvetica-Bold", 24, L2, center, bold, nohscroll;
	fontset = subtitle, "Helvetica-Bold", 18, L2, center, bold, nohscroll;
	fontset = subsubtitle, "Helvetica-Bold", 14, L2, center, bold, nohscroll;
	fontset = section, "Helvetica-Bold", 16, L2, bold, nohscroll, grayBox;
	fontset = subsection, "Helvetica-Bold", 13, L2, bold, nohscroll, blackBox;
	fontset = subsubsection, "Helvetica-Bold", 12, L2, bold, nohscroll, whiteBox;
	fontset = text, "Times-Roman", 12, L2, nohscroll;
	fontset = smalltext, "Times-Roman", 10, L2, nohscroll;
	fontset = input, "Courier-Bold", 12, L2, bold, nowordwrap;
	fontset = output, "Courier", 12, L2, nowordwrap;
	fontset = message, "Courier", 12, L2, R21845, G21845, B21845, nowordwrap;
	fontset = print, "Courier", 12, L2, nowordwrap;
	fontset = info, "Courier", 12, L2, nowordwrap;
	fontset = postscript, "Courier", 12, L2, nowordwrap;
	fontset = name, "Times-Italic", 11, L2, italic, R21845, G21845, B21845, nowordwrap, nohscroll;
	fontset = header, "Times", 10, L2;
	fontset = footer, "Times", 12, L2, center;
	fontset = help, "Times-Roman", 13, L2, nohscroll;
	fontset = clipboard, "New York", 12, L2;
	fontset = completions, "Courier", 16, L2, nowordwrap;
	fontset = network, "Courier", 10, L2, nowordwrap;
	fontset = graphlabel, "Courier", 12, L2, nowordwrap;
	fontset = special1, "New York", 12, L2, nowordwrap;
	fontset = special2, "New York", 12, L2, center, nowordwrap;
	fontset = special3, "New York", 12, L2, right, nowordwrap;
	fontset = special4, "New York", 12, L2, nowordwrap;
	fontset = special5, "New York", 12, L2, nowordwrap;]
:[font = title; inactive; ]
A Skeletal Package
:[font = text; inactive; ]
This is the skeletal package developed in Chapter 2.
:[font = subsubsection; inactive; locked; startGroup; Cclosed; ]
Copyright Notice
:[font = smalltext; inactive; locked; endGroup; ]

	Copyright 1989 by Roman Maeder.
	
	Adapted from	Roman E. Maeder: Programming in Mathematica, Addison-Wesley, 1989.
	
	Permission is hereby granted to make copies of	this file for any purpose other than direct profit,	or as part of a commercial product, provided this copyright notice is left intact.	Sale, other than for the cost of media, is prohibited.
	
	Permission is hereby granted to reproduce part or all of this file provided that the source is acknowledged.

:[font = section; inactive; startGroup; Cclosed; ]
Examples
:[font = subsection; inactive; startGroup; Cclosed; ]
Example Example
:[font = text; inactive; ]
Since this package does not much useful things, this example is pretty trivial.
:[font = input; ]
Function1[ 17 ]
:[font = input; ]
Function2[ 3 ]
:[font = text; inactive; ]
Your friendly error message....
:[font = input; endGroup; endGroup; ]
 Function2[ 6, 6]
:[font = section; inactive; startGroup; Cclosed; ]
Implementation
:[font = text; inactive; startGroup; Cclosed; ]
Set up the package context, included any imports
:[font = input; initialization; endGroup; ]
*)
BeginPackage["RMPackages`Skeleton`", "RMPackages`Package1`", "RMPackages`Package2`"]
(*
:[font = text; inactive; startGroup; Cclosed; ]
Read in any hidden imports
:[font = input; initialization; endGroup; ]
*)
Needs["RMPackages`Package3`"]
(*
:[font = text; inactive; startGroup; Cclosed; ]
Usage messages for the exported functions and the context itself
:[font = input; initialization; ]
*)
Skeleton::usage = "Skeleton.m is a package that does nothing."
(*
:[font = input; initialization; ]
*)
Function1::usage = "Function1[n] does nothing."
(*
:[font = input; initialization; endGroup; ]
*)
Function2::usage = "Function2[n, (m:17)] does even more nothing."
(*
:[font = text; inactive; startGroup; Cclosed; ]
begin the private context
:[font = input; initialization; endGroup; ]
*)
Begin["`Private`"]
(*
:[font = text; inactive; startGroup; Cclosed; ]
Unprotect any system functions for which rules will be defined
:[font = input; initialization; endGroup; ]
*)
protected = Unprotect[ Sin, Cos ]
(*
:[font = text; inactive; startGroup; Cclosed; ]
definition of auxiliary functions and local (static) variables
:[font = input; initialization; ]
*)
Aux[f_] := Do[something]
(*
:[font = input; initialization; endGroup; ]
*)
staticvar = 0
(*
:[font = text; inactive; startGroup; Cclosed; ]
Error messages for the exported objects
:[font = input; initialization; endGroup; ]
*)
Skeleton::badarg = "You twit, you called `1` with argument `2`!"
(*
:[font = text; inactive; startGroup; Cclosed; ]
Definition of the exported functions
:[font = input; initialization; ]
*)
Function1[n_] := n
(*
:[font = input; initialization; endGroup; ]
*)
Function2[n_, m_:17] := n m /; n < 5 || Message[Skeleton::badarg, Function2, n]
(*
:[font = text; inactive; startGroup; Cclosed; ]
Rules for system functions
:[font = input; initialization; endGroup; ]
*)
Sin/: Sin[x_]^2 := 1 - Cos[x]^2
(*
:[font = text; inactive; startGroup; Cclosed; ]
Restore protection of system symbols
:[font = input; initialization; endGroup; ]
*)
Protect[ Release[protected] ]
(*
:[font = text; inactive; startGroup; Cclosed; ]
End the private context
:[font = input; initialization; endGroup; ]
*)
End[]
(*
:[font = text; inactive; startGroup; Cclosed; ]
Protect exported symbols
:[font = input; initialization; endGroup; ]
*)
Protect[ Function1, Function2 ]
(*
:[font = text; inactive; startGroup; Cclosed; ]
End the package context
:[font = input; initialization; endGroup; endGroup; ]
*)
EndPackage[]
(*
^*)