(*^

::[paletteColors = 128; 
	fontset = title, "Helvetica-Bold", 24, L2, center, bold, nohscroll;
	fontset = subtitle, "Helvetica-Bold", 18, L2, center, bold, nohscroll;
	fontset = subsubtitle, "Helvetica-Bold", 14, L2, center, bold, nohscroll;
	fontset = section, "Helvetica-Bold", 16, L2, bold, nohscroll, grayBox;
	fontset = subsection, "Helvetica-Bold", 13, L2, bold, nohscroll, blackBox;
	fontset = subsubsection, "Helvetica-Bold", 12, L2, bold, nohscroll, whiteBox;
	fontset = text, "Times-Roman", 12, L2, nohscroll;
	fontset = smalltext, "Times-Roman", 10, L2, nohscroll;
	fontset = input, "Courier-Bold", 12, L2, bold, nowordwrap;
	fontset = output, "Courier", 12, L2, nowordwrap;
	fontset = message, "Courier", 12, L2, R21845, G21845, B21845, nowordwrap;
	fontset = print, "Courier", 12, L2, nowordwrap;
	fontset = info, "Courier", 12, L2, nowordwrap;
	fontset = postscript, "Courier", 12, L2, nowordwrap;
	fontset = name, "Times-Italic", 11, L2, italic, R21845, G21845, B21845, nowordwrap, nohscroll;
	fontset = header, "Times", 10, L2;
	fontset = footer, "Times", 12, L2, center;
	fontset = help, "Times-Roman", 13, L2, nohscroll;
	fontset = clipboard, "New York", 12, L2;
	fontset = completions, "Courier", 16, L2, nowordwrap;
	fontset = network, "Courier", 10, L2, nowordwrap;
	fontset = graphlabel, "Courier", 12, L2, nowordwrap;
	fontset = special1, "New York", 12, L2, nowordwrap;
	fontset = special2, "New York", 12, L2, center, nowordwrap;
	fontset = special3, "New York", 12, L2, right, nowordwrap;
	fontset = special4, "New York", 12, L2, nowordwrap;
	fontset = special5, "New York", 12, L2, nowordwrap;]
:[font = title; inactive; ]
Struve Functions
:[font = text; inactive; ]
This example comes from section 8.4.
:[font = subsubsection; inactive; locked; startGroup; Cclosed; ]
Copyright Notice
:[font = smalltext; inactive; locked; endGroup; ]

	Copyright 1989 by Roman Maeder.
	
	Adapted from	Roman E. Maeder: Programming in Mathematica, Addison-Wesley, 1989.
	
	Permission is hereby granted to make copies of	this file for any purpose other than direct profit,	or as part of a commercial product, provided this copyright notice is left intact.	Sale, other than for the cost of media, is prohibited.
	
	Permission is hereby granted to reproduce part or all of this file provided that the source is acknowledged.

:[font = section; inactive; startGroup; Cclosed; ]
Examples
:[font = subsection; inactive; startGroup; Cclosed; ]
A Plot of Struve Functions
:[font = text; inactive; ]
This will take a long time! See page 192.
:[font = input; endGroup; endGroup; ]
Plot[ {StruveH[0, x], StruveH[1, x], StruveH[2, x]},
	{x, 0, 13}, PlotRange -> {-0.3, 2} ];
:[font = section; inactive; startGroup; Cclosed; ]
Implementation
:[font = input; initialization; ]
*)
BeginPackage["RMPackages`Struve`"]
(*
:[font = input; initialization; ]
*)
StruveH::usage "StruveH[nu, z] gives the Struve function."
(*
:[font = input; initialization; ]
*)
Begin["`Private`"]
(*
:[font = input; initialization; ]
*)
Attributes[StruveH] = {Listable}
(*
:[font = text; inactive; initialization; startGroup; Cclosed; ]
special values
:[font = input; initialization; ]
*)
StruveH[r_Rational?Positive, z_] :=
	BesselY[r, z] +
	Sum[Gamma[m + 1/2] (z/2)^(-2m + r - 1)/Gamma[r + 1/2 - m], {m, 0, r-1/2}]/Pi /;
		Denominator[r] == 2
(*
:[font = input; initialization; endGroup; ]
*)
StruveH[r_Rational?Negative, z_] :=
	(-1)^(-r-1/2) BesselJ[-r, z] /; Denominator[r] == 2
(*
:[font = text; inactive; initialization; startGroup; Cclosed; ]
Series expansion
:[font = input; initialization; endGroup; ]
*)
StruveH/: Series[StruveH[nu_?NumberQ, z_], {z_, 0, ord_Integer}] :=
	(z/2)^(nu + 1) Sum[ (-1)^m (z/2)^(2m)/Gamma[m + 3/2]/Gamma[m + nu + 3/2],
	                   {m, 0, (ord-nu-1)/2} ] + O[z]^(ord+1)
(*
:[font = text; inactive; initialization; startGroup; Cclosed; ]
numerical evaluation
:[font = input; initialization; endGroup; ]
*)
StruveH[nu_?NumberQ, z_?NumberQ] :=
	Block[{s=0, so=-1, m=0, prec = Precision[z], 
	        z2 = -(z/2)^2,k1 = 3/2, k2 = nu + 3/2, g1, g2, zf},
		zf = (z/2)^(nu+1); g1 = Gamma[k1]; g2 = Gamma[k2];
		While[so != s,
			so = s; s += N[zf/g1/g2, prec];
			g1 *= k1; g2 *= k2; zf *= z2;
			k1++; k2++; m++
		];
		s
	]
(*
:[font = text; inactive; initialization; startGroup; Cclosed; ]
Derivatives
:[font = input; initialization; endGroup; ]
*)
Derivative[0, n_Integer?Positive][StruveH][nu_, z_] :=
	D[ (StruveH[nu-1, z] - StruveH[nu+1, z] + (z/2)^nu/Sqrt[Pi]/Gamma[nu + 3/2])/2,
	   {z, n-1} ]
(*
:[font = input; initialization; ]
*)
End[]
(*
:[font = input; initialization; ]
*)
Protect[StruveH]
(*
:[font = input; initialization; endGroup; ]
*)
EndPackage[]
(*
^*)