
(* :Title: Hcadlib *)

(* :Author: Junichi Nishimoto *)

(* :Summary: Functions for Hcad3D. *)

(* :Copyright: Copyright 1991-1992 *)

BeginPackage["Hcadlib`"]

MakeHcadFile::usage = 
 "MakeHcadFile[filename,data] makes the data file for Hcad3D by 
 formatting the data.The data must be lists of the planes' side and center.
 If the side is not entered, it is regarded as outside.
 For example data = {{0,1.0,2.0,2.0},{2,4.3,2.0,-4.0},{2.9,1.1,3.2}}"


Begin["`Private`"]

ChangeForm[pnt_] :=
	Block[{str,ap},
		ap = pnt;
		If[N[Abs[ap[[1]]]]<0.000001,ap[[1]] = 0];
		If[N[Abs[ap[[2]]]]<0.000001,ap[[2]] = 0];
		If[N[Abs[ap[[3]]]]<0.000001,ap[[3]] = 0];

		If[Length[ap] == 4,
			If[N[Abs[ap[[4]]]]<0.000001,ap[[4]] = 0];
			str = StringJoin[ToString[ap[[1]]]," (",
				ToString[ap[[2]]],",",ToString[ap[[3]]],
				",",ToString[ap[[4]]],")"],
			str = StringJoin["0 (",
				ToString[ap[[1]]],",",ToString[ap[[2]]],
				",",ToString[ap[[3]]],")"]];
		Return[str];
	]
  
MakeHcadFile[fname_,data_] :=
	Block[{i},
		OpenWrite[fname];
		Do[Write[fname,OutputForm[ChangeForm[data[[1]]]]],
			{i,Length[data]}];
		Close[fname];
	]




End[ ]

EndPackage[ ]
