/*****************************************************************/
/*                                                               */
/*          Copyright (c) 1991-1992 by J.Nisimoto                */
/*                                                               */
/*                   H  c  a  d  3  D  - Ver 2.0                 */
/*                                                               */
/*  Permission to use,copy,modify,and distribute this software.  */
/*                                                               */
/*  help_menu.c: Functions for help menu window.                 */
/*                                                               */
/*                                                               */
/*****************************************************************/

#include <stdio.h>   
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <math.h>
#include <ctype.h>
#include <string.h>
#include "source/Hcad.h"

#include "source/Hcadext.h"

/*------------------------------------------------------------

  Function : help_menu(int)

-------------------------------------------------------------*/
help_menu(invert_num)
int invert_num;
{

	int looping,i,mouse_in;
	char text_buffer[40], s[5];
	int text_width;
	XSetWindowAttributes  atr;

	sub_menuhint.x = 10;
	sub_menuhint.y = 40;
	sub_menuhint.width =790;
	sub_menuhint.height =600;
	sub_menuhint.flags = PPosition | PSize;

	sub_menuwin = XCreateSimpleWindow(disp,basewin,sub_menuhint.x,sub_menuhint.y,
	sub_menuhint.width,sub_menuhint.height,
	2,black,white);
	sub_menugc = XCreateGC(disp,sub_menuwin,0,0);
	XSetBackground(disp,sub_menugc,white);
	XSetForeground(disp,sub_menugc,black);
	XSetFunction(disp,sub_menugc,GXcopy);
        if(font_flg == TRUE){
          XSetFont(disp,sub_menugc,font);
        }
	atr.save_under = True;
	XChangeWindowAttributes(disp,sub_menuwin,CWSaveUnder,&atr);
	XMapRaised(disp,sub_menuwin);
	XDrawRectangle(disp,sub_menuwin,sub_menugc,3,3,784,594);
	XDrawRectangle(disp,sub_menuwin,sub_menugc,6,6,778,588);
	switch(invert_num){
	case 0:
		help_about_file();
		break;
	case 1:
		help_about_data();
		break;
	case 2:
		help_about_print();
		break;
	case 3:
		help_about_select();
		break;
	case 4:
		help_about_demo();
		break;
	case 5:
		help_about_other();
		break;
	case 6:
		help_about_mouse();
		break;
	default:
		break;
	}
	looping = 0;
	XWarpPointer(disp,None,sub_menuwin,0,0,0,0,300,300);
	mouse_in = 0;
	while(looping == 0){
		if(XEventsQueued(disp,QueuedAfterReading)==0){
			XFlush(disp);
		}
		XNextEvent(disp,&ev);

		switch(ev.type){
		case MotionNotify:
			if(ev.xmotion.subwindow != sub_menuwin){
				looping = 1;
			}

			break; 
		default:
			break;
		}
	}
	XFreeGC(disp,sub_menugc);
	XDestroyWindow(disp,sub_menuwin);
}      

/*------------------------------------------------------------

  Function : print_win(int,int,char *)

-------------------------------------------------------------*/
print_win(x,y,text)
int x;
int y;
char text[];
{
	XDrawString(disp,sub_menuwin,sub_menugc,x,y,text,strlen(text));
}

/*------------------------------------------------------------

  Function : help_about_file()

-------------------------------------------------------------*/
help_about_file(){
	XDrawRectangle(disp,sub_menuwin,sub_menugc,200,20,400,30);
	print_win(250,45,"How to use File Menu");
	print_win(30,80,"File Menu consists of the next 6 submenus");
	print_win(40,110,"* present situation -- Show the present file,the file directory which has the");
	print_win(60,130,"data file for drawing,and the working directory in which Hcad3D  makes");
	print_win(60,150,"a temporary file for printing and saves the data of");
	print_win(60,170,"the objects on the drawing window.");
	print_win(40,190,"* open  -- Open a data file of objects for drawing.");
	print_win(40,230,"* save  -- Save the data of the objects on the drawing window.");
	print_win(40,270,"* file directory -- Enter the name of the data file directory.");
	print_win(40,310,"* working directory -- Enter the name of the working directory.");
	print_win(40,350,"* Quit -- Exit from Hcad3D.");
}

/*------------------------------------------------------------

  Function : help_about_data()

-------------------------------------------------------------*/
help_about_data(){
	XDrawRectangle(disp,sub_menuwin,sub_menugc,200,20,400,30);
	print_win(250,45,"How to use Data Menu");
	print_win(30,80,"Data Menu consists of the next 6 submenus");
	print_win(40,110,"* show -- Show the data (the center,the radius and the side) of one of the planes");
	print_win(60,130,"on the drawing window");
	print_win(40,150,"* add -- Add new plane.By the <data style>,you enter some coordinate (x,y,z),");
	print_win(60,170,"decide the side and click the [Add] button , then the new plane is added to the objects");
	print_win(60,190,"on the drawing window.");
	print_win(40,210,"* change -- Change the data of the plane on the drawing window.");
	print_win(60,230,"The way to enter the data is as same as <add>.");
	print_win(40,250,"* remove -- Deleate a plane.");
	print_win(40,290,"* clear all -- Clear all planes.");
	print_win(40,310,"* data style -- Select the data style you want to use.");
	print_win(60,330,"1 Input one point:at which the plane has the center.");
	print_win(60,350,"2 Input two points:between which the plane bisects the segment");
	print_win(65,370,"in Euclidean metric perpendicularly.");
	print_win(60,370,"3 Input three points:by which the plane is spanned.");
}

/*------------------------------------------------------------

  Function : help_about_print()

-------------------------------------------------------------*/
help_about_print(){
	XDrawRectangle(disp,sub_menuwin,sub_menugc,200,20,400,30);
	print_win(250,45,"How to use Print Menu");
	print_win(30,80,"Print Menu consists of the next 4 submenus");
	print_win(40,110,"* print -- Print out the polyhedron on the drawing window.Before first printing");
	print_win(60,130,"you have to set the working directory.");
	print_win(40,150,"* make PS file -- Make a Postscript file for printing");
	print_win(40,190,"* set print command -- Enter the command to print out the Postscript file.");
	print_win(40,210,"* setting -- Set representations for printing.");
}

/*------------------------------------------------------------

  Function : help_about_select()

-------------------------------------------------------------*/
help_about_select(){
	XDrawRectangle(disp,sub_menuwin,sub_menugc,200,20,400,30);
	print_win(250,45,"How to use Select Menu");
	print_win(30,80,"Select Menu consists of the next 2 submenus");
	print_win(40,110,
	"* select plane -- The boundary of selected plane is drawn by thick lines.");
	print_win(40,140,
	"* select line  -- The selected line is drawn by thick line, and");
	print_win(40,170,
	"                      the length and angle are displayed");

}

/*------------------------------------------------------------

  Function : help_about_other()

-------------------------------------------------------------*/
help_about_other(){
	XDrawRectangle(disp,sub_menuwin,sub_menugc,200,20,400,30);
	print_win(250,45,"How to use Other Menu");
	print_win(30,80,"Other Menu isn't supported yet.");
}

/*------------------------------------------------------------

  Function : help_about_demo()

-------------------------------------------------------------*/
help_about_demo(){
	XDrawRectangle(disp,sub_menuwin,sub_menugc,200,20,400,30);
	print_win(250,45,"How to use Demo Menu");
	print_win(30,80,"Demo Menu shows the next 5 hyperbolic polyhedrons");
	print_win(40,110,"* tetrahedron           -- Show the regular hyperbolic tetrahedron.");
	print_win(40,150,"* octahedron            -- Show the regular hyperbolic octahedron.");
	print_win(40,190,"* truncated tetrahedron -- Show the truncated tetrahedron");
	print_win(40,230,"* dodecahedron          -- Show the regular hyperbolic dodecahedron");
	print_win(40,270,"* icosahedron           --  Show the regular hyperbolic icasahedron");
}


/*------------------------------------------------------------

  Function : help_about_mouse()

-------------------------------------------------------------*/
help_about_mouse(){

	XDrawRectangle(disp,sub_menuwin,sub_menugc,200,20,400,30);
	print_win(250,45,"How to rotate the object.");
	XDrawRectangle(disp,sub_menuwin,sub_menugc,100,150,600,300);
	XDrawLine(disp,sub_menuwin,sub_menugc,100,130,700,130);
	XDrawLine(disp,sub_menuwin,sub_menugc,100,130,100,150);
	XDrawLine(disp,sub_menuwin,sub_menugc,700,130,700,150);
	print_win(110,145,"File        Data        Print        Select");
	print_win(410,145,"Help        Demo        Other        Setting");
	XSetLineAttributes(disp,sub_menugc,0,LineOnOffDash,CapNotLast,JoinMiter);
	XDrawLine(disp,sub_menuwin,sub_menugc,100,250,700,250);
	XDrawLine(disp,sub_menuwin,sub_menugc,100,350,700,350);
	XDrawLine(disp,sub_menuwin,sub_menugc,300,150,300,450);
	XDrawLine(disp,sub_menuwin,sub_menugc,500,150,500,450);
	XSetLineAttributes(disp,sub_menugc,0,LineSolid,CapNotLast,JoinMiter);
	print_win(120,200,"Click here,then");
	print_win(120,220,"rotated upward left.");
	print_win(320,200,"Click here,then");
	print_win(320,220,"rotated upward.");
	print_win(520,200,"Click here,then");
	print_win(520,220,"rotated upward right.");
	print_win(120,300,"Click here,then");
	print_win(120,320,"rotated left.");
	print_win(320,300,"Click here,then");
	print_win(320,320,"the object is rotated");
	print_win(320,340,"to the initial position.");
	print_win(520,300,"Click here,then");
	print_win(520,320,"rotated right.");
	print_win(120,400,"Click here,then");
	print_win(120,420,"rotated downward left.");
	print_win(320,400,"Click here,then");
	print_win(320,420,"rotated downward.");
	print_win(520,400,"Click here,then");
	print_win(520,420,"rotated downward right.");
}







