/*
### create an execution window ###
*/

#include <suntool/sunview.h>
#include <suntool/panel.h>
#include <suntool/textsw.h>


void create_exec_windows()
{

	extern int ycanvas,ywidth,b_margin;
	extern short exec_panel_show;
	extern Frame frame,exec_frame;
	extern Panel exec_panel;
	extern Panel_item exec_panel_quit_item,exec_panel_go_item, exec_panel_load_item,
		exec_dir_name_item, exec_file_name_item, exec_input_name_item;
	extern Textsw exec_textsw;
	extern Textsw_status exec_status; 
	extern Pixfont *boldfont;
	extern int panel_colormap_on;
	extern char string[],exec_dir_name[],exec_file_name[],exec_input_name[];
        void exec_panel_quit_proc(),exec_panel_go_proc(),exec_panel_load_proc();

	if(exec_panel_show){
		window_set(exec_frame,WIN_SHOW, TRUE,0);
		return;
	}
	else
		exec_panel_show = 1;
        exec_frame = window_create(frame,FRAME,FRAME_LABEL,"execution",
                FRAME_SHOW_LABEL,       TRUE,
		FRAME_NO_CONFIRM,	TRUE,
                WIN_SHOW,       TRUE,
                WIN_X, 400,
		WIN_WIDTH,	400,
		WIN_HEIGHT,	300,
                0);
	if(exec_frame == NULL) {
		system_mess_proc(1,"No more windows. Clean up some windows to make room.");
		exec_panel_show = 0;
		return;
	}
        exec_panel = window_create(exec_frame, PANEL,
		WIN_X,	0,
		WIN_Y,	0,
		0);
	if(exec_panel == NULL) {
		system_mess_proc(1,"No more windows. Clean up some windows to make room.");
		(void) destroy_exec_windows();
		return;
	}
        exec_panel_quit_item= panel_create_item(exec_panel,PANEL_BUTTON,
                PANEL_LABEL_Y,  ATTR_ROW(0),
                PANEL_LABEL_X,  ATTR_COL(0),
                PANEL_LABEL_IMAGE,panel_button_image(exec_panel,"Quit",8,boldfont),
                PANEL_NOTIFY_PROC,exec_panel_quit_proc,
                0);
        exec_panel_go_item= panel_create_item(exec_panel,PANEL_BUTTON,
                PANEL_LABEL_Y,  ATTR_ROW(0),
                PANEL_LABEL_X,  ATTR_COL(10),
                PANEL_LABEL_IMAGE,panel_button_image(exec_panel,"Go",8,boldfont),
                PANEL_NOTIFY_PROC,exec_panel_go_proc,
                0);
        exec_panel_load_item= panel_create_item(exec_panel,PANEL_BUTTON,
                PANEL_LABEL_Y,  ATTR_ROW(0),
                PANEL_LABEL_X,  ATTR_COL(20),
                PANEL_LABEL_IMAGE,panel_button_image(exec_panel,"Load",8,boldfont),
                PANEL_NOTIFY_PROC,exec_panel_load_proc,
                0);
        exec_dir_name_item = panel_create_item(exec_panel,PANEL_TEXT,
                PANEL_LABEL_Y,  ATTR_ROW(1),
                PANEL_LABEL_X,  ATTR_COL(0),
                PANEL_VALUE,    exec_dir_name,
                PANEL_VALUE_DISPLAY_LENGTH, 40,
                PANEL_LABEL_STRING, "Dir:",
                0);
        exec_file_name_item = panel_create_item(exec_panel,PANEL_TEXT,
                PANEL_LABEL_Y,  ATTR_ROW(2),
                PANEL_LABEL_X,  ATTR_COL(0),
                PANEL_VALUE,    exec_file_name,
                PANEL_VALUE_DISPLAY_LENGTH, 40,
                PANEL_LABEL_STRING, "Exec File:",
                0);
        exec_input_name_item = panel_create_item(exec_panel,PANEL_TEXT,
                PANEL_LABEL_Y,  ATTR_ROW(3),
                PANEL_LABEL_X,  ATTR_COL(0),
                PANEL_VALUE,    exec_input_name,
                PANEL_VALUE_DISPLAY_LENGTH, 40,
                PANEL_LABEL_STRING, "Input File:",
                0);
        window_fit_height(exec_panel);

	if(panel_colormap_on)
		init_panel_colormap((Pixwin *) window_get(exec_panel,WIN_PIXWIN),"exec_panel_cms");

        sprintf(string,"%s/%s",exec_dir_name,exec_input_name);
        exec_textsw = window_create(exec_frame, TEXTSW,
		0);
	if(exec_textsw == NULL) {
		system_mess_proc(1,"No more windows. Clean up some windows to make room.");
		(void) destroy_exec_windows();
		return;
	}
	window_set(exec_textsw,
                TEXTSW_STATUS, &exec_status,
                TEXTSW_FILE,string,
                TEXTSW_FIRST,0,
                0);
        if(exec_status == TEXTSW_STATUS_CANNOT_OPEN_INPUT){
                printf("File (%s) does not exist!\n",string);
        }       
	if(panel_colormap_on)
		init_panel_colormap((Pixwin *) window_get(exec_textsw,WIN_PIXWIN),"exec_textsw_cms");

}

