/*
### draw and record an orbit in periodic, full, window coords ###
=========================================================
Input:	record_on: 0: draw only, 1: draw and record
	color: 
	s_type:
	s_size:
	p_type:
	x[n]: orbit in euclidean or window coords
----------------------------------------------------------
NOTE: recording done on phase or parameter space data
----------------------------------------------------------
*/

void draw_record_pwf(x,color,s_type,s_size,p_type,record_on)
int color,s_type,s_size,p_type,record_on;
double x[];
{
	int i,color_index;
	extern int var_dim,polar_coord,enable_period;
	extern double *t_v,*t_vf;

	if(enable_period)
		make_periodic(t_v,x,var_dim);
	else
		for(i=0;i<var_dim;i++)t_v[i]=x[i];
	to_full_variables(t_vf,t_v,polar_coord);
	all_pen_down(1,t_vf,color,s_type,s_size,p_type);
	if(record_on) {
		encode_color_symbol(&color_index,color,s_type);
		record_data(t_vf,color_index);
	}
}
