/*
Compute periodic orbit of a period r by secant method
(Solve F(x)=f^r(x)-x-xoffset= 0)
------------------------------------------------------
Note:	x[0...n-1] convention 
	All computation in Euclidean coords
	
Input:	x[n]= current guess, n= phase space dimension, r= period
	tolx= tolerated error in x (sum), tolf= tolerated error in F(x) (sum)
	ntrial = # of maximum secant step
Output:	x[n]=new guessed solution, *ndid= acutal # of secant step done,
	*err= actual error in x (sum)
*/

#define DELTAX 1.e-6
#define FREERETURN {*ndid = k;free_dmatrix(alpha,0,n-1,0,n-1);free_dvector(x2,0,n-1);free_dvector(xt,0,n-1);free_dvector(beta,0,n-1);\
	free_ivector(indx,0,n-1);return;}

void msecant(x,ntrial,n,r,tolx,tolf,err,ndid)
int ntrial,n,r,*ndid;
double x[],tolx,tolf,*err;
{
	int i,j,k,*indx,*ivector();
	double tolx10,fabs(),errf,d,*x2,*xt,*beta,**alpha,*dvector(),**dmatrix();
	void usrfun(),usrfun2(),usrfun3(),ludcmp(),lubksb(),free_dmatrix(),free_ivector(),free_dvector();
	extern int stop,enable_period,cur_color,model,mapping_on,fderiv_on;

	indx = ivector(0,n-1);
	x2 = dvector(0,n-1);
	xt = dvector(0,n-1);
	beta = dvector(0,n-1);
	alpha = dmatrix(0,n-1,0,n-1);

	tolx10 = tolx /10;
	*err = 1.e30;
	/* initial second guess */
	for(i=0;i<n;i++) x2[i] = x[i] + DELTAX;

	for(k=0;k<ntrial;k++){
		if(mapping_on){
			if(fderiv_on)
				usrfun(x,alpha,beta,r,n);
			else
				usrfun2(x,x2,alpha,beta,r,n);
		}
		else {
			usrfun3(x,x2,alpha,beta,r,n);
		}
		if(enable_period==1){
			dist_periodic(xt,beta,n);
			for(i=0;i<n;i++)beta[i]=xt[i];
		}
		/*
		printf("NTRIAL=%d\n",k);
		printf("usrfun x: ");
		for(i=0;i<n;i++) printf("%g ",x[i]);	
		printf("\n");
		printf("usrfun f: ");
		for(i=0;i<n;i++) printf("%g ",beta[i]);	
		printf("\n");
		printf("usrfun alpha:");
		for(j=0;j<n;j++){
			for(i=0;i<n;i++) printf("%g ",alpha[j][i]);	
			printf("\n");
		}
		*/

		errf = 0.0;
		for(i=0;i<n;i++) errf += fabs(beta[i]);
		if(errf <= tolf) FREERETURN

		ludcmp(alpha,n,indx,&d);
		/* should be placed here not to proceed further
		in case of singular matrix (singular matrix often
		arise when all the machine accuracy was lost in
		computing alpha. This happens in case of good
		convergence,too) */
		if(stop){
			FREERETURN
		}
		/*
		for(j=0;j<n;j++){
			for(i=0;i<n;i++) printf("%g ",alpha[j][i]);	
			printf("\n");
		}
		*/
		lubksb(alpha,n,indx,beta);

		/*
		printf("new beta:");
		for(i=0;i<n;i++) printf("%g ",beta[i]);	
		printf("\n");
		*/
		*err = 0.0;
		for(i=0;i<n;i++){
			*err += fabs(beta[i]);
			x2[i] = x[i];
			x[i] -= beta[i];
		}
		if(*err <= tolx) FREERETURN
		for(i=0;i<n;i++) if(fabs(beta[i]) < tolx10) x[i] -= tolx10;

		/* draw intermediate steps */
		(void) draw_record_pwf(x,cur_color,1,3,1,0);
		(void) draw_record_pwf(x,cur_color,1,3,1,0);
	}
	FREERETURN
}
