/*
### procedure for saving and loading data ###
*/

#include <stdio.h>

void save_data_proc()
{
	int             i, j;
	extern FILE *fopen(),*ffp;
	extern int func_on,region_index,new_data_format;
	extern int var_dim,func_dim,param_dim,full_dim;
	extern int stop, n_stored_data1,n_stored_data0,save_option,var_dim,param_dim,var_cur_index[],param_cur_index[];
	extern char string[],full_path[],dir_name[],file_name[];
        extern int *data0_color,*data1_color,*data2_color;
        extern double **data0_x,**data1_x,**data2_x;

	stop = 0;

	/* Return if non-save options are chosen */
	if(save_option == 3 || save_option ==4 || save_option ==8){
		sprintf(string,"Error: This option %d is not for save!",save_option);
		system_mess_proc(1,string);
		return;
	}
	
	all_reset();

	/* Open a file  for writing */
	sprintf(full_path, "%s/%s", dir_name, file_name);
	ffp = fopen(full_path, "w");
	if(ffp ==NULL){
		fclose(ffp);
		sprintf(string,"Cannot open file %s!",full_path);
		system_mess_proc(1,string);
		return;
	}

	/* save the key header */
	if(new_data_format==1){
		fprintf(ffp, "%%%%TS\n");
	}
	else if(new_data_format==0){
		fprintf(ffp, "%%%%T\n");
	}
	else {
	}

	/* Save window parameters */
	save_param(ffp);

	if(new_data_format==1){
		fprintf(ffp, "%%%%TE\n");
	}
	else if(new_data_format==0){
	}
	else {
	}

	/* Return if "window parameters only" options are chosen */
	if(save_option == 0 || save_option == 5) {
		fclose(ffp);
		return;
	}

	/* Otherwise, save the data */
	/* phase space box data */
	if(region_index==1){
		for (i = 0; i < n_stored_data1; i++) {
			/* window data options */
			if (save_option == 1 || save_option == 6) {
				fprintf(ffp, "%%XC%d", data1_color[i]);
				fprintf(ffp, " %.14lg %.14lg\n", data1_x[var_cur_index[0]][i], data1_x[var_cur_index[1]][i]);
			}

			/* all data options */
			else if (save_option == 2 || save_option == 7) {
				fprintf(ffp, "%%XC%d", data1_color[i]);
				for (j = 0; j < var_dim; j++)
					fprintf(ffp, " %.14lg", data1_x[j][i]);
				if(save_option == 7 && func_on){
					for (j = var_dim; j < full_dim; j++)
						fprintf(ffp, " %.14lg", data1_x[j][i]);
				}
				fprintf(ffp, "\n");
			}

			if (stop) {
				break;
			}
		}
	}
	/* parameter space box data */
	else if(region_index==0){
		for (i = 0; i < n_stored_data0; i++) {
			/* window data options */
			if (save_option == 1 || save_option == 6) {
				fprintf(ffp, "%%XC%d", data0_color[i]);
				fprintf(ffp, " %.14lg %.14lg\n", data0_x[param_cur_index[0]][i], data0_x[param_cur_index[1]][i]);

			}

			/* all data options */
			else if (save_option == 2 || save_option == 7) {
				fprintf(ffp, "%%XC%d", data0_color[i]);
				for (j = 0; j < param_dim; j++)
					fprintf(ffp, " %.14lg", data0_x[j][i]);
				fprintf(ffp, "\n");
			}

			if (stop) {
				break;
			}
		}
	}
	else {
		/* install the case of region_index=2 */
		system_mess_proc(1,"Wrong region index! Click SHIFT-LEFT on either boxes and try again");
	}

	fclose(ffp);
}
