/*
Initialize all parameters for a given dynamical system to be installed
Parameters are assigned to the default values before this program is called.
-----------------------------------------------------------------------
This is a GENERIC subroutine. If you want, you can change
the name string "userds0" to a proper one globally in this program
but then you need to change the same strings in the header file defining
the current class of dynamical systems.
*/

/*
Example 1: map with periodic variable
*/

#include "model.h"

int userds0_init()
{
	title_label = "AIDS Multi-group Model";
	mapping_on = 0;
	inverse_on = 1;
	fderiv_on = 0;
	enable_polar = 0;
	enable_period = 0;

	var_dim = 4;
	param_dim = 13;
	func_dim = 2;

	(void) malloc_init();

	var_label[0] = "S1";
	var_label[1] = "S2";
	var_label[2] = "I1";
	var_label[3] = "I2";
	
	param_label[0] = "c1";
	param_label[1] = "c2";
	param_label[2] = "n1";
	param_label[3] = "n2";
	param_label[4] = "l11";
	param_label[5] = "l12";
	param_label[6] = "l21";
	param_label[7] = "l22";
	param_label[8] = "l1";
	param_label[9] = "l2";
	param_label[10] = "g1";
	param_label[11] = "g2";
	param_label[12] = "m";

	func_label[0] = "B1";
	func_label[1] = "B2";

	var_i[0] = 55000;
	var_i[1] = 5500;
	var_i[2] = 100;
	var_i[3] = 100;

	param[12] = 1./30;

	param[0] = 430;
	param[1] = 43;
	param[2] = .9;
	param[3] = .8;
	param[4] = .1;
	param[5] = .01;
	param[6] = .15;
	param[7] = .09;
	param[8] = var_i[0]*param[12];
	param[9] = var_i[1]*param[12];
	param[10] = .1;
	param[11] = .1;

	var_min[0]= 0; var_max[0]= 60000;
	var_min[1]= 0; var_max[1]= 10000;
	var_min[2]= 0; var_max[2]= 3000;
	var_min[3]= 0; var_max[3]= 500;

	param_min[12]= 0; param_max[12]= .1;

	param_min[0]= 0; param_max[0]= 700;
	param_min[1]= 0; param_max[1]= 100;
	param_min[2]= 0; param_max[2]= 1;
	param_min[3]= 0; param_max[3]= 1;
	param_min[4]= 0; param_max[4]= 1;
	param_min[5]= 0; param_max[5] = 1;
	param_min[6]= 0; param_max[6]= 1;
	param_min[7]= 0; param_max[7]= 1;
	param_min[8]= 0; param_max[8]= 6000;
	param_min[9]= 0; param_max[9]= 1000;
	param_min[10]= 0; param_max[10]= 1;
	param_min[11]= 0; param_max[11]= 1;

	/* dynamical system and function pointer assignments */
	f_p = userds0_f;
	func_p = userds0_func;
}
/*
first user dynamical system
*/
	
double F1,F2;
int userds0_f(f,index,x,p,t,dim)
int index,dim;
double f[],x[],p[],t;
{
	double s1,s2,i1,i2;
	double c1,c2,n1,n2,l11,l12,l21,l22,l1,l2,g1,g2,m,D1;

	s1 = x[0];
	s2 = x[1];
	i1 = x[2];
	i2 = x[3];
	c1 = p[0];
	c2 = p[1];
	n1 = p[2];
	n2 = p[3];
	l11 = p[4];
	l12 = p[5];
	l21 = p[6];
	l22 = p[7];
	l1 = p[8];
	l2 = p[9];
	g1 = p[10];
	g2 = p[11];
	m = p[12];
	D1 = (1-n1)*c1*(s1+i1)+(1-n2)*c2*(s2+i2);
	F1 = c1*s1*(l11*(n1 + (1-n1)*(1-n1)*c1*(s1+i1)/D1)*i1/(s1+i1)
		+ l12*(1-n1)*(1-n2)*c2*(s2+i2)/D1*i2/(s2+i2));
	F2 = c2*s2*(l22*(n2 + (1-n2)*(1-n2)*c2*(s2+i2)/D1)*i2/(s2+i2)
		+ l21*(1-n1)*(1-n2)*c1*(s1+i1)/D1*i1/(s1+i1));
	f[0] = l1 - F1 - m*s1;
	f[1] = l2 - F2 - m*s2;
	f[2] = F1 - (m+g1)*i1;
	f[3] = F2 - (m+g2)*i2;
}
/*
first user function subroutine
*/

int userds0_func(f,x,p,t,dim)
double f[],x[],p[],t;
int dim;
{
	extern double F1,F2;
	f[0] = F1;
	f[1] = F2;
}
