 /*
  * Khoros: $Id: elas.h,v 1.1 1991/05/10 04:13:15 khoros Exp $
  */

 /*
  * $Log: elas.h,v $
 * Revision 1.1  1991/05/10  04:13:15  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 *
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 *
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1990 by UNM */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>     file name: elas.h                                 <<<<
   >>>>                                                       <<<<
   >>>>      contains: contains defines to ELAS image         <<<<
   >>>>                 file format.                          <<<<
   >>>>                                                       <<<<
   >>>>      written by: Charlie Gage                         <<<<
   >>>>                                                       <<<<
   >>>>      date: 2/4/91                                     <<<<
   >>>>                                                       <<<<
   >>>>      modifications:                                   <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */


/*
 *
 *      The "elas" image file format describes the image format
 *      used by the ELAS system.
 *
 *      Record 1 contains all the header information, which is of length
 *      256 words or 1024 bytes.  The remaining records,
 *      beginning with record 2 store image data one scanline at a time
 *      in (BIL) band-interleaved-by-line format for any number of bands.
 *      Since a scanline has a variable number of pixels depending on
 *      the original data, each scanline is divided into an appropriate
 *      number of records (512 pixels per record). If the number of
 *      pixels per scanline is not evenly divisible by 512, then the
 *      last record for each line will contain the remainder for
 *      that line; it will be only partially full. Note, records are
 *      padded to a length of 512.
 *
 *      The Band-Interleaved-By-Line order means that the first scanline
 *      of the first band is stored first. It is followed by the first
 *      scanline of the second band, third band, fourth band, and so on
 *      up to the last band avaliable. This order then repeats for
 *      the second scanline, the third scanline and so on.
 *
 */


#ifndef _elas_h_
#define _elas_h_

struct elas {

	int	num_hdr_bytes;       /* NBIH - Number of bytes in header */
	int  	num_bytes_record;    /* NBPR - Number of bytes per record, */
                                     /*  one record contains 1 line of */
                                     /*  1 channel */
	int	init_line;           /* IL - Initial line of data file */
	int	last_line;           /* LL - Last line of data file */
	int	init_elem_scan_line; /* IE - Initial element of each scan line */
	int	last_elem_scan_line; /* LE - Last element of each scan line */
	int	num_channels;        /* NC - Number of channels (ie. bands) */
	int	header_id;           /* Header record identification */
	char	grid_desc_y[4];      /* Grid descriptor for Y-axis */
	int	y_offset;            /* Y coordinate system value for scan line 0 */
	char	grid_desc_x[4];      /* Grid descriptor for X-axis */
	int	x_offset;            /* X coordinate system value for element 0 */
	float	y_spot_size;         /* The pixel element height */
	float	x_spot_size;         /* The pixel element width */
	float	trans_matrix_il;     /* Transformation matrix from line and */
	float	trans_matrix_ll;     /*  column (IL, LL, IE, LE) coordinates to */
	float	trans_matrix_ie;     /*  the coordinates described in Grid */
	float	trans_matrix_le;     /*  descriptor for X and Y axis. */
                                     /*  1., 0., 0., 1.  = identity transformation */
                                     /*  1., 0., 0., -1. = data in the UTM format */
	char	reserved1[12];       /* Not used */
	int	eikonix;             /* Used by modules RFEKDA and VEKS */
	int	labl;                /* Used by module LABL */
	char	head[4];             /* Used by module HEAD */
	char	comments[384];       /* Comments - 6 lines at 64 characters each or */
                                     /*  96 4-character descriptors for */
                                     /*  data base use */
	int	color_tbl[128];      /* Color table */
	char	reserved2[32];       /* Not used */
	char 	*imagedata;          /* Image data */
};


 /*  Image Data:     Most image data are stored as one data value
  *    per byte (exception, see Note 3).  If the data file contains more
  *    than one channel, the channels are stored successively for each
  *    scan line.  For example, a data file with three channels that
  *    started at scan line number 1 would be formatted according to the
  *    following scheme:   Record Number     Data Description      
  *                             1            Header Record        
  *                             2            Scan line 1, channel 1 
  *                             3            Scan line 1, channel 2
  *                             4            Scan line 1, channel 3 
  *                             5            Scan line 2, channel 1
  *                            etc.                   etc.        
  *
  *    In ELAS, data file I/O is handled by the RDWR subroutine. 
  *
  *  NOTE 3: One exception is the 16-bit elevation data available 
  *     from NCIC. In this case the 16-bit values are retained until
  *     slope and aspect are computed. The data are stored in an ELAS
  *     data file by doubling the value in the header record that
  *     specifies the number of elements.
  *
  *  The above information was obtained from the ELAS manual.
  */


 /* Define a structure to pass from the library routine to
  * read_elas_line() and write_elas_line().
  * Each time the above routines are called, the fileptr is
  * updated to reflect the current position into the ELAS image.
  */
struct elas_coords {
        int    x_init;     /* requested x offset into image */
        int    skip;       /* number of image data bytes to skip */
        int    wid;        /* requested width of image */
        int    rec_length; /* size in bytes of ELAS image record */
        int    pad;        /* number of pad bytes to end of record */
        int    fid;        /* file descriptor of ELAS image */
        char   *buf;       /* pointer to current scan line buffer */
};

 /* Typedefs for the above structures */
typedef struct elas ELAS;
typedef struct elas_coords ECOORD;

#endif

/* Don't add after the endif */

