 /*
  * Khoros: $Id: match_loc.c,v 1.1 1991/05/10 15:40:47 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: match_loc.c,v 1.1 1991/05/10 15:40:47 khoros Exp $";
#endif

 /*
  * $Log: match_loc.c,v $
 * Revision 1.1  1991/05/10  15:40:47  khoros
 * Initial revision
 *
  */ 

/*
#
# FILE NAME:	match_loc.c
# 
# AUTHORS:	Tom Sauer, Marcelo Teran, John Rasure
# 
# DATE:		2/6/89
# 
# DESCRIPTION:	Contains module match_loc_type().
# 
# MODIFICATIONS:
#		John Rasure modified error messages.
#		Sun Jun  3 00:21:55 MDT 1990
# 
# ROUTINES:	match_loc_type()
#		
*/

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.

 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */

#include "vinclude.h"	  


/**************************************************************
*
* MODULE NAME: 	match_loc_type()
*
*     PURPOSE:	Check to see that two viff data structures have the same
*		location type.
*
*       INPUT:  prog 	- program name
*		*img1	- viff data structure one
*		*img2	- viff data structure two
*		exit_flag
*
*      OUTPUT:  If exit_flag is true and match fails, an error 
*          	message is printed.
*      		If exit_flag is false and match fails, return(0).
*
*       USAGE:	If exit_flag is set, The routine will print out an
*		error message and then exit().  In this case, the
*		function should be declared (void).  If exit_flag
*               is not set (equal 0) then the function should be
*		declared int.
*
*
**************************************************************/

match_loc_type(prog,img1,img2,exit_flag)
char *prog;
struct xvimage *img1,*img2;
int exit_flag;
{
    if (img1->location_type != img2->location_type) {
	if (exit_flag == TRUE) {
		(void) fprintf(stderr,"\nError in program %s.\n",prog);
		(void) fprintf(stderr,
"The viff data structures have incompatible location types.\n");
		(void) fprintf(stderr,
"One may be implied while the other is explicit.\n");
		exit(1);
	}
	else return(0);
    }
return(1);
}
