 /*
  * Khoros: $Id: bin_search.c,v 1.1 1991/05/10 15:41:06 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: bin_search.c,v 1.1 1991/05/10 15:41:06 khoros Exp $";
#endif

 /*
  * $Log: bin_search.c,v $
 * Revision 1.1  1991/05/10  15:41:06  khoros
 * Initial revision
 *
  */ 

/******************************************************************

	Binary Search Routine for key in the answer file array

	source filename:			bin_search.c

	revision	  date			programmer
	--------	  ----			----------
	   0.0		Jan-05-85		don hush

******************************************************************

	usage
	-----

	sarg = bin_search(key)

	char *sarg,*key;

	description
	-----------

	  This routine uses a binary search to search the answer
	file array for a match to the key. If one is found this 
	returns a pointer to the string argument (parameter) 
	associated with that key in the array. If no match is
	found then a NULL is returned.

******************************************************************/
#include "vgparm.h"

char *bin_search(key)

char *key;

{
	extern int num_args;
	extern ARG_ENTRY **arg_table;

	int high,mid,low;
	int test;

	high = num_args-1;
	low = 0;

	while (low<=high) {
	    mid = low + (high-low)/2;
	    test = strcmp(key,arg_table[mid]->key);
	    if (test>0)
		low = mid+1;
	    else if (test<0)
		high = mid-1;
	    else
		return(arg_table[mid]->sarg);
	}
	return(NULL);
}
