 /*
  * Khoros: $Id: vgparml.c,v 1.1 1991/05/10 15:41:06 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vgparml.c,v 1.1 1991/05/10 15:41:06 khoros Exp $";
#endif

 /*
  * $Log: vgparml.c,v $
 * Revision 1.1  1991/05/10  15:41:06  khoros
 * Initial revision
 *
  */ 

/******************************************************************

	Get Logical Parameter 

	source filename:			vgparml.c

	revision	  date			programmer
	--------	  ----			----------
	   0.0		May-1-85		don hush

******************************************************************

usage :
	vgparml(ifd,key,prompt,larg,imax,imin,ierr)

	int ifd,*larg,imax,imin,*ierr ;
	character *key,*prompt ;

description :
  This routine fetches a 'logical' parameter from either the
command line , an answer file , or the user (interactively).
The answer file must be opened prior to	calling this routine.
If no answer file is present then ifd should be passed as an
illegal (negative) file descriptor. The command line is searched
first, then the answer file (if one has been opened).
If a parameter is not found to	match the key on the command
line or in the answer file , the user is prompted interactively
for the parameter. If prompt = "noprompt" when no match 
is found then the query	to the user is suppressed and
a default parameter value is returned (assumed 0).
The imax,imin, and ierr arguments have no meaning in this routine
and are included only for consistancy with the other vgparm routines.

argument descriptions :

	ifd -	C file descriptor for the answer file ;
		If there is no answer file ifd should be
		passed as an invalid (negative) file descriptor

	key -	search key used to locate the parameter ;
		It must begin with a '-' and be the first thing
		to appear in the line in the answer file (no 
		leading spaces).
		A maximum of 1 character can follow the '-'
		to make up the key.  Case distinctions are made
		when parsing the key , so upper and lower case
		letters are not treated the same.

	prompt - prompt used to query the user if no match
		is found for the key. If prompt = "noprompt"
		then the query is suppressed and a default
		value for the parameter is returned with
		an error code of -1 .

	imax -	not used

	imin -	not used

	larg - 	argument (parameter) value returned 
		0 false
		1 true

	ierr -	not used

******************************************************************/

#include "vgparm.h"

extern int first_time,make;
extern char make_name[];

vgparml(ifd,key,prompt,larg,imax,imin,ierr)

int ifd,*larg,imax,imin,*ierr;
char *key,*prompt;

{
    if (first_time) {
	first_time = FALSE;
	make = init_makec();
    }

    if ( strcmp(key,"nokey") == 0 )
	*ierr = get_arg_user(prompt,larg,'l');
    else {
        if ( (*ierr=get_arg_clc(key,larg,'l')) == -1 )
	    if ( (*ierr=get_arg_afile(ifd,key,larg,'l')) == -1 )
	        *ierr=get_arg_user(prompt,larg,'l');
    }


    if ( strcmp(key,"nokey") != 0 )
        if ((*ierr==0)&&(make))
	    put_line(key,larg,'l');

}
