 /*
  * Khoros: $Id: file_type.c,v 1.4 1992/03/25 17:31:00 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: file_type.c,v 1.4 1992/03/25 17:31:00 dkhoros Exp $";
#endif

 /*
  * $Log: file_type.c,v $
 * Revision 1.4  1992/03/25  17:31:00  dkhoros
 * VirtualPatch5
 *
 * Revision 1.2  1991/12/18  09:56:33  dkhoros
 * HellPatch3
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.

 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "vinclude.h"	
#include "readbuffer.h"

/************************************************************
*
*  MODULE NAME: check_file_type
*
*      PURPOSE: checks the input file to see if it is 
*               an KHOROS file, and find out what type
*               it is. Currently only IFF exists, but others may
*               be added inthe future.
*
*        INPUT: name of the file
*
*       OUTPUT: integer 0 : not an KHOROS file
*                       1 : IFF
*
*    CALLED BY:
*
*   WRITTEN BY: Danielle Argiro and Mark Young
*   MODIFIED BY: Scott Wilson, Updated to XV III 27-Feb-89
*
*
*************************************************************/

#define NONE 0
#define IFF 1

int check_file_type(fid)
int fid;
{
	int		num = -1, block_read();
	unsigned char 	identifier, release_num, version_num, file_type;


	if (block_read(fid, &identifier, 1) != 1)
	{
	   (void) fprintf(stderr,"\ncheck_file_type: Incorrect byte count ");
	   (void) fprintf(stderr," reading in identifier!\n");
	   num = 0;
	}
	else if (block_read(fid, &file_type, 1) != 1)
	{
	   (void) fprintf(stderr,"\ncheck_file_type: Incorrect byte count ");
	   (void) fprintf(stderr," reading in file type!\n");
	   num = 1;
	}
	else if (block_read(fid, &release_num, 1) != 1)
	{
	   (void) fprintf(stderr,"\ncheck_file_type: Incorrect byte count ");
	   (void) fprintf(stderr," reading in release number!\n");
	   num = 2;
	}
	else if (block_read(fid, &version_num, 1) != 1)
	{
	   (void) fprintf(stderr,"\ncheck_file_type: Incorrect byte count ");
	   (void) fprintf(stderr," reading in version number!\n");
	   num = 3;
	}

	/*
	 * check for wrong identifier 
	 */
	else if (identifier != XV_FILE_MAGIC_NUM) 
	{
	   /* (void) fprintf(stderr,"\n\ncheck_file_type: ");
	   (void) fprintf(stderr," Unexpected Identifier -- \n");
           (void) fprintf(stderr,"not an Khoros Image File (viff).\n\n"); */
	   num = 3;
	}

	/* 
	 * check for wrong release and/or version number
	 */
	else if ((release_num != XV_IMAGE_REL_NUM) || 
	    (version_num != XV_IMAGE_VER_NUM)) 
	{
	   (void) fprintf(stderr,"\nCheck_File_Type: \n");
	   (void) fprintf(stderr,"   Incompatible file release number %1d.%1d\n", 
			      version_num, release_num);
	   (void) fprintf(stderr,"   Currently using Khoros release %1d.%1d\n", 
			      XV_IMAGE_VER_NUM, XV_IMAGE_REL_NUM);

	   num = 3;
	}

	/* Now look at the file type, and return a number telling what
	   kind of KHOROS file this is. Currently, only VIFF is
	   defined, but others may be defined in the future */
	else if (file_type != XV_FILE_TYPE_XVIFF)
	{
	   num = 3;
        }


	if (num != -1)
	{
	   if (klseek(fid, 0L, 0) != -1)
	      return(NONE);

	   num_buffer = 0;
	   if (num > 0) read_buffer[num_buffer++] = identifier;
	   if (num > 1) read_buffer[num_buffer++] = file_type;
	   if (num > 2) read_buffer[num_buffer++] = release_num;
	   if (num > 3) read_buffer[num_buffer++] = version_num;
	   return(NONE);
	}

        /* valid IFF File */
        return(IFF);
}
