 /*
  * Khoros: $Id: ldscale.c,v 1.2 1992/03/20 23:29:01 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: ldscale.c,v 1.2 1992/03/20 23:29:01 dkhoros Exp $";
#endif

 /*
  * $Log: ldscale.c,v $
 * Revision 1.2  1992/03/20  23:29:01  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: ldscale.c
 >>>>
 >>>>      Program Name: dscale
 >>>>
 >>>> Date Last Updated: Sat Feb 15 16:36:02 1992 
 >>>>
 >>>>          Routines: ldscale - the library call for dscale
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: ldscale - library call for dscale
*
* Purpose:
*    
*    1D Rescale Data
*    
*    

* Input:
*    
*    image          pointer to VIFF structure containing image data to
*                   be processed.
*    
*    scale          scale factor by which to multiply all elements  in
*                   the data set.
*    
*    procdir        process direction:  0  indicated  vector  oriented
*                   processing, 1 indicates band oriented processing.
*    
*    

* Output:
*    
*    image          pointer to VIFF structure  containing  image  data
*                   after processing.
*    
*    Return Value:  1 on success, 0 on failure.
*    
*    

*
* Written By: Ramiro Jordan, Jeremy Worley
*    
*    Jeremy Worley 23-Jul-90       Modified declaration  and  call  to
*                                  dload_vector()  to  conform  to new
*                                  character oriented specifications.
*    
*    

****************************************************************/


/* -library_def */
int
ldscale ( image, scale, process_dir)

struct xvimage *image;
int    process_dir;
float  scale;
/* -library_def_end */

/* -library_code */
{
    int   i, dimension, num_vects, size;
    int   lscale(), dunload_vector();
    float **data; 
    char **dload_vector();

    char *program = "ldscale";

    if((data = (float **)dload_vector(image, &num_vects, &dimension, 
               process_dir)) == NULL)
    {
      (void) fprintf(stderr,"%s: dload_vector failed \n",program);
      return(0);
    }

    size = dimension;
    if(image->data_storage_type==VFF_TYP_COMPLEX)size *=2;

    for ( i = 0; i < num_vects; i++ )
    {
        if ( !lscale ( data[i], size, scale ) )
        {
           (void) fprintf ( stderr,"ldscale failed\n");
           return(0);
        }
    }

    if (!dunload_vector((char **)data,image,image->data_storage_type,num_vects,
         dimension, process_dir))
    {
       (void) fprintf (stderr,"%s: dunload_vector failed \n",program);
       return(0);
    }
 
    return(1);

} /* end of ldscale */


/***********************************************************************
*
*  Routine Name: lscale 
*
*          Date:
*        
*       Purpose:  
*
*         Input: data sequence to scale and length of data sequence
*
*        Output: scaled data sequence 
*
*    Written By: Ramiro Jordan 
*
* Modifications:
*
***********************************************************************/

int
lscale ( datain, points, scale )

int    points;
float  *datain, scale;
{
    int   i;

    /* scale data record */
    for ( i = 0; i < points; i++ )
    {
        datain[i] *= scale;
    }

    return(1);

} /* end of lscale */
/* -library_code_end */
