 /*
  * Khoros: $Id: ldsubsamp.c,v 1.2 1992/03/20 23:29:15 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: ldsubsamp.c,v 1.2 1992/03/20 23:29:15 dkhoros Exp $";
#endif

 /*
  * $Log: ldsubsamp.c,v $
 * Revision 1.2  1992/03/20  23:29:15  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: ldsubsamp.c
 >>>>
 >>>>      Program Name: dsubsamp
 >>>>
 >>>> Date Last Updated: Wed Feb 19 09:23:00 1992 
 >>>>
 >>>>          Routines: ldsubsamp - the library call for dsubsamp
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: ldsubsamp - library call for dsubsamp
*
* Purpose:
*    
*    Subsamples 1-D vector(s).
*    
*    

* Input:
*    
*    *image         (struct xvimage) -  pointer  to  the  input/output
*                   xvimage structure
*    
*    skip           (int) - subsampling skip value
*    
*    start          (int) - first sample point
*    
*    process_dir    (int) - data processing direction.  0 = vector,  1
*                   = band.
*    
*    

* Output:
*    
*    *image         (struct xvimage) -  pointer  to  the  input/output
*                   xvimage structure
*    
*    

*
* Written By: Donna Koechner
*    
*    Donna Koechner 7 Jun 1990 22:53:23 MDT
*                                  updated to use ghostwriter.
*    
*    Jeremy Worley 19 Feb 1992 09:21 MST
*                                  made   implicit   declaration    of
*                                  dunload_vector() explicit.
*    
*    

****************************************************************/


/* -library_def */
int
ldsubsamp(image, skip, start, process_dir)

struct xvimage  *image;         /* input/output image */
int             skip,           /* skip value */
                start,          /* insert point */
                process_dir;    /* direction of processing 0=vect, 1= band */
/* -library_def_end */

/* -library_code */
{ 

  int           arith,                  /* scale factor: real=1, cmplx=2 */
                num_vects,              /* number of vectors */
                dimension,              /* dimension of vectors */
                out_dim,                /* dimension of subsampled vectors */
                i, j, m;                /* loop variables */

  float         **data,                 /* input data array */
                **out_data;             /* shifted data array */

  char          **dload_vector();
  int           dunload_vector();


 /*
  * If skip value = zero, and no offset into data, return.
  */
  if ( (skip == 0) && (start == 0) )
  {
    return(1);
  }

 /*
  * Set up arithmetic type
  */
  arith = 1;
  if (image->data_storage_type == VFF_TYP_COMPLEX)
  {
    arith = 2;
  }

 /*
  * Call dload_vector for input image
  */
  if ( ( data = (float **)dload_vector(image, &num_vects, &dimension, 
                process_dir)) == NULL)
  {
    (void)fprintf(stderr,"ldsubsamp: dload_vector failed\n");
    return(0);
  }

 /*
  * Make sure dimension is greater than 0.
  */
  if (dimension < 1 )
  {
    (void)fprintf(stderr,"ldsubsamp: invalid vector dimension --> %d\n",
                  dimension);
    return(0);
  }

 /* 
  * Verify that skip and start values are in bounds.
  */
  if ( start >= dimension )
  {
    (void)fprintf(stderr,"ldsubsamp: starting point out of bounds\n");
    (void)fprintf(stderr,"starting point = %d, dimension = %d\n",
                  start, dimension);
    return(0);
  }

  if ( (skip >= (dimension-start)) || (skip < 0) )
  {
    (void)fprintf(stderr,"ldsubsamp: skip factor out of bounds\n");
    (void)fprintf(stderr,"skip factor = %d, dimension = %d, first point =%d\n",
                  skip, dimension, start);
    return(0);
  }

 /*
  * Calculate final output dimension.
  */
  out_dim = ( (dimension - 1 - start)/(skip + 1) ) + 1;

 /*
  * Allocate array for subsampled data.
  */
  if ( (out_data = (float **) (malloc ((unsigned int) num_vects *
        sizeof(float))) ) == NULL)
  {
    (void) fprintf(stderr,"ldsubsamp: Cannot allocate for sampled array.\n");
    return(0);
  }
  for (i=0; i<num_vects; i++)
  {
    if ((out_data[i] = (float *) (malloc ((unsigned int) out_dim * arith *
         sizeof(float) ))) == NULL)
    {
      (void)fprintf(stderr,"ldsubsamp: Cannot alloc for sampled array.\n");
      return(0);
    }
  }

 /*
  * Subsampling Code
  */

 /*
  * Increment skip so we don't have to do it 80 million times.
  */
  skip++;
  
  if (arith == 1)
  {
    for ( i=0; i<num_vects; i++)
    {
      m=0;
      for ( j=start; j<dimension; j+=skip)
      {
          out_data[i][m] = data[i][j];
          m++;
      }  
    }  
  }

  else  /* complex data */
  {
    skip *= arith;
    start *= arith;
    dimension *= arith;

    for ( i=0; i<num_vects; i++)
    {
      m=0;
      for ( j=start; j<dimension; j+=skip)
      {
          out_data[i][m] = data[i][j];
          m++;
          out_data[i][m] = data[i][j+1];
          m++;
      }  
    }  
  }

 /*
  * Unload the shifted vector array back into the image
  */
  if (!(dunload_vector((char **)out_data, image, image->data_storage_type, 
                       num_vects, out_dim, process_dir)) )
  {
    (void)fprintf(stderr,"ldsubsamp: dunload_vector failed!\n");
    return(0);
  }

  for (i=0; i<num_vects; i++)
  {
    free((char*)data[i]);
    free((char*)out_data[i]);
  }
  free((char**)data);
  free((char**)out_data);
  return(1);

}  /* end of ldsubsamp */
/* -library_code_end */
